#ifndef _LCD3300_H_
#define _LCD3300_H_

// Port definition
#define LCD_SCK   PD4
#define LCD_RESET PD3
#define LCD_CS    PD1
#define LCD_SDATA PD2
#define LCD_PORT  PORTD
#define LCD_DDR   DDRD
#define LCD_PIN   PIND
#define LCD_MASK  (0xFF - ((1<<LCD_SCK) | (1<<LCD_RESET) | (1<<LCD_CS) | (1<<LCD_SDATA)))

// Declared functions
void LCD3300_PowOff(void);
void LCD3300_Init(void);
void LCD3300_WriteCommand(uint8_t data);
void LCD3300_WriteData(uint8_t data);
uint8_t LCD3300_DrawRect(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, uint8_t color);
uint8_t LCD3300_DrawText(const char* text, uint8_t x0, uint8_t y0, uint8_t bgColor, uint8_t textColor);
void LCD3300_ClearDisplay(void);
uint8_t LCD3300_DrawBigText(const char* text, uint8_t x0, uint8_t y0, uint8_t bgColor, uint8_t textColor);
uint8_t LCD3300_DrawBarGraph(uint8_t value, uint8_t x0, uint8_t y0, uint8_t bgColor, uint8_t barColor);

void LCD3300_SleepIn(void);
void LCD3300_SleepOut(void);

#define DISCTL	0b10101110
#define COMSCN	0b10111011 //1
#define TMPGRD	0b10000010 //14
#define OSCON	0b11010001
#define OSCOFF	0b11010010
#define SLPIN	0b10010101
#define SLPOUT	0b10010100
#define VOLCTR	0b10000001 //2
#define PWRCTR	0b00100000 //1
#define DISNOR	0b10100110
#define DISINV	0b10100111
#define PTLIN	0b10101000 //2
#define PTLOUT	0b10101001
#define ASCSET	0b10101010 //4
#define SCSTART	0b10101011 //1
#define DATCTL	0b10111100 //3
#define RGBSET8	0b11001110 //20
#define PASET	0b01110101 //2
#define CASET	0b00010101 //2
#define RAMWR	0b01011100
#define DISON	0b10101111
#define DISOFF	0b10101110

#endif
