###
### Web ̃Recǂ perl XNvg
### A perl script to retrieve contents on the internet via http.

### (C) 2001-2004 }  (web@kasai.fm) ŏIXV: 2004N 3 5
### (C) 2001-2004 Takafumi Kasai           Last modified: 5 May, 2004

### {XNvǵARɓ]ځEpEzzEgpEςĂČ\łB
### AǍʉ炩̑QꍇAӔC𕉂˂܂B
### 炩߂B

### ƌ̍DbłAoO△ʂȕ𔭌܂AL
### AhX܂ł񒸂΍KłB

### You can quote, distribute, use, and alter this script without 
###  any permission. But I never bear responsibility for any possible
###  damage by this script.  However, I hope to receive reports of
###  bugs or wasteful part in this script from you.

# ==============================================================

# e v / Requirements
#
# Eperl 5 ȍ~ / perl 5 or later
# Eȉ perl W[ / perl modules follows:
#      Socket
#      FileHandle
#      MIME::Base64
# (ActivePerl ɕt̂̂ACPAN _E[ĥʓrpӉ)
# (You can get them from ActiveStates or CPAN)

# e gp@ / Usage
#
# (1) ̃XNvg(getHTTP)A@INC ɃpX̒ʂꏊɒuB
# (2) ĂяõvOŁA
#       require('getHTTP');
#     ƏB
# (3) 
#       ($http_response, $errorMessage) = &getHTTP('http://www.kasai.fm/');
#     ̂悤ɁAWeb ̃Recǂ݂߂B

#     $http_response ɁAǂݍ񂾃RecB
#     G[NƁA$errorMessage ɃG[RB

# (1) Put this script where @INC can reach.
# (2) In the caller script, put this code:
#     require('getHTTP');
# (3) 
#     ($http_response, $errorMessage) = &getHTTP('http://www.kasai.fm/');
#    will retrieve contents on the internet.

# e F؂̕Kvȃy[Wꍇ / In case authorization required

# ($http_response, $errorMessage) = &getHTTP('URL'=>'http://www.kasai.fm/',
#  'UserID'=>'Mihata', 'Password'=>'Tatenashi');

# e vNVgꍇ / In case you use a proxy 

# ($http_response, $errorMessage) = &getHTTP('URL'=>'http://www.kasai.fm/', 'Proxy'=>'someproxy.com:8080');

# e F؂̕KvȃvNVgꍇ / In case you use a proxy which requires authorization

# ($http_response, $errorMessage) = &getHTTP('URL'=>'http://www.kasai.fm/', 'Proxy'=>'someproxy.com:8080',
#  'ProxyUserID'=>'Alladin', 'ProxyPassword'=>'open_sesami');

# ==============================================================

use Socket;
use FileHandle;
use MIME::Base64;
#require('BASE64');

sub getHTTP{
	local $\ = "";

	my %arg = ( @_ );
	my $data;
	my ( $uri, $proxy_address, $proxy_port, $http_version, $user_id, $password,
		$proxy_user_id, $proxy_password, $referrer, $referer, $agent ) =
	(
		$arg{URL}           || $_[0],
		$arg{Proxy}         || "",
		$arg{ProxyPort}     || "8080",
		$arg{HTTP}          || "1.1",
		$arg{UserID}        || "",
		$arg{Password}      || "",
		$arg{ProxyUserID}   || "",
		$arg{ProxyPassword} || "",
		$arg{Referrer}      || "",
		$arg{Referer}       || "",
		$arg{UserAgent}     || "HTTP client version 1.02 (www.kasai.fm)"
	);

	my ( $scheme, $domain, $server_address, $server_port, $path );
	my ( $target_address, $target_port, $target_path, $target_ip );


######### URI parsing

	### retrieve scheme ( "http://" )
	
	if ( $uri =~ s!^(\w+?)://!! ){
		$scheme = $1;
		
		return ("",
			"Can't handle '$scheme'. Only 'http' is possible"
		) if ( $scheme !~ /^http$/i );
	}
	else{
		$scheme = 'http';
	}


	### retrieve domain, port and path ( "hogehoge:8080/foo/bar.html" )
	
	( $domain, $path ) = split( /\//, $uri, 2 );
	( $server_address, $server_port ) = split( /:/, $domain, 2 );
	
	$server_address ||= "localhost";
	$server_port ||= getservbyname( $scheme, "tcp" );
	#Added by Hiro
	$server_port =~ /^\d+$/ or $server_port = 80; 

	### complete info about your proxy server

	if ( $proxy_address and !$proxy_port ){
		( $proxy_port ) = $proxy_address =~ /:(\d+)/;
		
		return ("",
			"Proxy port is undefined.".
			"Specify 'ProxyPort'=>8080 or 'Proxy'=>'${proxy_address}:8080'"
		) unless ( $proxy_port );
	}


	### switch arguments according to if you use a proxy server
	
	( $target_address, $target_port, $target_path ) = $proxy_address ?
		(
			$proxy_address,
			$proxy_port,
			"${scheme}://${server_address}:${server_port}/${path}"
		) :
		(
			$server_address,
			$server_port,
			"/$path"
		);


 ######### SOCKET (create)
 
	$target_ip    = inet_aton( $target_address ) || return ("", "Can't connect to $target_address" );
	$target_port =~ /^(\d+)$/ || return ("", "Can't get target_port $target_port for $target_address" );

	$sock_address = pack_sockaddr_in( $target_port, $target_ip );
	socket(SOCKET, PF_INET, SOCK_STREAM, getprotobyname( 'tcp' )) || return ("", "Can't create socket on $target_address");	# Added by Hiro
	#socket(SOCKET, PF_INET, SOCK_STREAM, 0) || return ("", "Can't create socket on $target_address");


 ######### SOCKET (connect)
 
	#connect( SOCKET, pack( 'S n a4 x8', PF_INET, $target_port, $target_ip) ) or return ("", "Can't connect socket on $sock_address:$target_port");	# Added by Hiro
	connect(SOCKET, $sock_address) or return ("", "Can't connect socket on $sock_address");
	#select( SOCKET ); $| = 1; select( STDOUT );	# Added by Hiro
	autoflush SOCKET (1);

 ######### Send HTTP GET request
 
	if ( $http_version eq "1.1" ) {
		print SOCKET "GET $target_path HTTP/1.1\n";
		print SOCKET "Host: $target_address\n";
		print SOCKET "Connection: close\n";
	}
	else {
		print SOCKET "GET $target_path HTTP/1.0\n";
	}

	if ( $user_id ){
		print SOCKET "Authorization: Basic\n ";
		print SOCKET &base64'b64encode("${user_id}:${password}")."\n";
	}

	if ( $proxy_user_id ){
		print SOCKET "Proxy-Authorization: Basic\n ";
		print SOCKET &base64'b64encode("${proxy_user_id}:${proxy_password}")."\n";
	}

	print SOCKET "User-Agent: $agent\n"  if ( $agent    );
	print SOCKET "Referrer: $referrer\n" if ( $referrer );
	print SOCKET "Referer: $referer\n"   if ( $referer  );

	print SOCKET "Accept: text/html; */*\n";
	print SOCKET "\n";


	######### Receive HTTP response via SOCKET

	while ( <SOCKET> ) {
		chomp;
		$data .= "$_\n";
	}


	######### SOCKET (close); take down the session
	
	close(SOCKET);


	######### return

	return ($data, "");
}

1;
