/*
  LScript Layout
  AlignToPath_ds
  V1.1
  Daisuke Suzuki
  History: 2014/09/11
*/

//-----------------------------------------

@name AlignToPath_ds
@script generic
@version 2.5
@warnings

generic
{
  scn = Scene();
  selected_Item = scn.getSelect();
  
  if(selected_Item == nil)
    {
	  error("Please select the object.");
	  return;
    }
  Item_name = selected_Item[1].name;
  fsel = scn.firstSelect();
  chan = fsel.firstChannel();
  KeyCnt = chan.keyCount;
  Skip_Num = 1;
  
  var1 = false;
  var2 = false;
  var3 = 0;
  var4 = false;
  var5 = 1;
  var6 = 1;
  var7 = false;
  var8 = 1;
  var9 = 1;
  var10 = false;
  var11 = 1;
  var12 = 1;

  
  reqbegin("AlignToPath_ds");
  reqsize(260,196);
  
  s0 = ctlsep(0,259);
    ctlposition(s0,0,45);
	
  s0 = ctlsep(0,259);
    ctlposition(s0,0,130);
	
  c0 = ctltext("","Key Count : [ " + KeyCnt + " ]");
    ctlposition(c0,138,143,50,10);
	
  c0 = ctltext("",": "+Item_name);
    ctlposition(c0,120,18,50,10);
  
  c1 = ctlcheckbox("K",var1);//K
    ctlposition(c1,20,15);
	
  c2 = ctlchoice("",var2,@"-Z","+Z"@);
    ctlposition(c2,59,15);
	
  c3 = ctlminislider("NextKey+",var3,0,KeyCnt - 1);
    ctlposition(c3,15,140,90,18);
	
  c4 = ctlcheckbox("H",var4);//Head
    ctlposition(c4,20,60);
	
  c5 = ctlchoice("",var5,@"+180","-180"@);
    ctlposition(c5,60,60);
	
  c6 = ctlminislider("x",var6,1,100);
    ctlposition(c6,142,60);
	
  c7 = ctlcheckbox("P",var7);//Pitch
    ctlposition(c7,20,80);
	
  c8 = ctlchoice("",var8,@"+180","-180"@);
    ctlposition(c8,60,80);
	
  c9 = ctlminislider("x",var9,1,100);
    ctlposition(c9,142,80);
	
  c10 = ctlcheckbox("B",var10);//Bank
    ctlposition(c10,20,100);
	
  c11 = ctlchoice("",var11,@"+180","-180"@);
    ctlposition(c11,60,100);
	
  c12 = ctlminislider("x",var12,1,100);
    ctlposition(c12,142,100);
	
	
	ctlactive(c1,"Zcl",c2);
	ctlactive(c4,"Hcl",c5,c6);
	ctlactive(c7,"Pcl",c8,c9);
	ctlactive(c10,"Bcl",c11,c12);
	
	return if !reqpost();


	var1 = getvalue(c1);
	var2 = getvalue(c2);
    var3 = getvalue(c3);
	var4 = getvalue(c4);
	var5 = getvalue(c5);
	var6 = getvalue(c6);
	var7 = getvalue(c7);
	var8 = getvalue(c8);
	var9 = getvalue(c9);
	var10 = getvalue(c10);
	var11 = getvalue(c11);
	var12 = getvalue(c12);

	reqend();
	
	if(var2 == 1)
	{
      zc1 = true;
    }
    if(var2 == 2)
	{
      zc2 = true;
    }
	

	if(var5 == 1)
	{
      hc1 = true;
    }
    if(var5 == 2)
	{
      hc2 = true;
    }

	if(var8 == 1)
	{
      pc1 = true;
    }
    if(var8 == 2)
	{
      pc2 = true;
    }
	
	if(var11 == 1)
	{
      bc1 = true;
    }
    if(var11 == 2)
	{
      bc2 = true;
    }
	
//-----------------------------------------ALIGN TO PATH KEY

    for(i = 0 ; i <= var3 ; i ++)
    {
	    if(Skip_Num >= 2)
		{
		 NextKey();
		}
         fps = scn.fps;
         ImaTime = scn.currenttime;
         ImaFrame = ImaTime*fps;
	 
        //Key
        if(var1)
        {
            if(zc1)//-Z
	        {
			 SelectByName(Item_name);
	         HController(5);
             PController(5);
	         RefreshNow();
             CreateKey(ImaTime);
	         HController(1);
             PController(1);
             item_rot = selected_Item[1].getRotation(ImaTime);
			    if(item_rot.h < 0)
				{
				 syusei_h = item_rot.h + 180;
				 syusei_p = item_rot.p * -1;
				 Rotation(syusei_h, syusei_p, item_rot.b);
				 h_ceil = ceil(syusei_h / 180)*360;
				 h_kaisu = abs(h_ceil / 360);
				    if(syusei_h < 0)
					{
					 syusei2_h = syusei_h + (-360*h_kaisu);
					 Rotation(syusei2_h, syusei_p, item_rot.b);
					 CreateKey(ImaTime);
					}
				}
			    if(item_rot.h > 0)
				{
				 syusei_h = item_rot.h - 180;
				 syusei_p = item_rot.p * -1;
				 Rotation(syusei_h, syusei_p, item_rot.b);
				 h_floor = floor(syusei_h / 180)*360;
				 h_kaisu = abs(h_floor / 360);
				 
				    if(syusei_h > 0)
					{
					 syusei2_h = syusei_h + (360*h_kaisu);
					 Rotation(syusei2_h, syusei_p, item_rot.b);
					 CreateKey(ImaTime);
	                }
				}
	        }
	        if(zc2)//+Z
	        {
	         SelectByName(Item_name);
	         HController(5);
             PController(5);
	         RefreshNow();
             CreateKey(ImaTime);
	         HController(1);
             PController(1);
	        }
        }
        //-----------------------------------------FLIP
        //H
        if(var4)
        {
            if(hc1)//+H
	        {
	         AddRotation(180*var6,0,0);
	         CreateKey(ImaTime);
	        }
	        if(hc2)//-H
	        {
	         AddRotation(-180*var6,0,0);
	         CreateKey(ImaTime);
	        }
        }
        //P
        if(var7)
        {
            if(pc1)//+P
	        {
	         AddRotation(0,180*var9,0);
	         CreateKey(ImaTime);
	        }
	        if(pc2)//-P
	        {
	         AddRotation(0,-180*var9,0);
	         CreateKey(ImaTime);
	        }
        }
        //B
        if(var10)
        {
            if(bc1)//+B
	        {
	         AddRotation(0,0,180*var12);
	         CreateKey(ImaTime);
	        }
	        if(bc2)//-B
	        {
	         AddRotation(0,0,-180*var12);
	         CreateKey(ImaTime);
	        }
        }

	 Skip_Num ++;
    }
}
  
Zcl: value
{
  return(value==1);
}
Hcl: value
{
  return(value==1);
}
Pcl: value
{
  return(value==1);
}
Bcl: value
{
  return(value==1);
}