/*
  LScript Layout
  CameraRig_ds
  V1.0
  Daisuke Suzuki
  History: 2014/10/13
*/

//-----------------------------------------

@name CameraRig_ds
@script generic
@version 2.6
@warnings

generic
{
    scn = Scene();
    selected_Item = scn.getSelect();
	
	if(selected_Item == nil)
	{
	  error("Please select the camera.");
	  return;
	}
    if(!selected_Item[1].isCamera())
    {
	  error("Please select the camera.");
	  return;
    }
	selected_size = selected_Item.size();
	sel_name = selected_Item[selected_size].name;
	camera = Camera(selected_Item[1].name);
	
    A_pos = scn.schemaPosition(sel_name);
    A_pos_x = A_pos[1];
    A_pos_y = A_pos[2];
	
    w_cam_position = selected_Item[selected_size].getWorldPosition(0);
    w_cam_rotation = selected_Item[selected_size].getWorldRotation(0);
	
	var1 = 1;
	
	choice[1] = "Simple";
	choice[2] = "Handy";
	choice[3] = "Crane";
	
    reqbegin("CameraRig_ds");
    reqsize(204,68);
	
	c1 = ctlchoice("Camera",var1,choice);
    ctlposition(c1,10,10);
	
	return if !reqpost();
	
	var1 = getvalue(c1);
	
	reqend();
	
//-----------------------------------------
    if(var1 == 1)
	{
	 dof(var1, sel_name, camera, A_pos_x, A_pos_y);
	}
	if(var1 == 2)
	{
	 name = sel_name + "_base";
	 create_null(name, w_cam_position, w_cam_rotation);
	 SchematicPosition((A_pos_x) , (-1.6+A_pos_y));
	 ItemColor(1);
	 
	    Skip_Num = 1;
	 	for(i = 1 ; i <= 4 ; i ++)
	    {
		 b_name[1] = "Shake";
		 b_name[2] = "Frequency";
		 b_name[3] = "Y";
		 b_name[4] = "Noise";
		 AddNull(sel_name+"_"+b_name[i] + "_base");
		 ItemLock(1);
         ItemVisibility(1);
		 ParentItem(sel_name + "_base");
		 SchematicPosition((1.4 + A_pos_x) , (1.0 - i + A_pos_y));
		 Position(0.5,0.5-(i*0.2),0);
		 Rotation(0,0,0);
		 
		 AddNull(sel_name+"_"+b_name[i] + "_Space");
		 ItemLock(1);
		 ItemColor(1);
		 ParentItem(sel_name+"_"+b_name[i] + "_base");
		 SchematicPosition((1.4 + A_pos_x) , (1.2 - i + A_pos_y));
		 Position(0.5,0,0);
		 Rotation(0,0,0);
		 Scale(1.0,0.025,0.0);
		 scn = Scene();
         sel_Item = scn.getSelect();
	     sel_size = sel_Item.size();
	     item = sel_Item[sel_size];
	     customshape(item, 1, 0, 1.0, 1, nil);
		 
		 AddNull(sel_name+"_"+b_name[i]);
		 ParentItem(sel_name+"_"+b_name[i] + "_base");
		 SchematicPosition((2.6 + A_pos_x) , (1.2 - i + A_pos_y));
		 Position(0,0,0);
		 Rotation(0,0,0);
		 Col_Num[1] = 11;
		 Col_Num[2] = 9;
		 Col_Num[3] = 10;
		 Col_Num[4] = 14;
		 ItemColor(Col_Num[i]);
		 MoveTool();
         EnableYP();
         EnableZB();
         RotateTool();
         EnableXH();
         EnableYP();
         EnableZB();
	     StretchTool();
	     EnableXH();
         EnableYP();
         EnableZB();
		 LimitX();
		 XLimits(0.0,1.0);
		 scn = Scene();
         sel_Item = scn.getSelect();
	     sel_size = sel_Item.size();
	     item = sel_Item[sel_size];
	     SelectItem(sel_name+"_"+b_name[i] + "_base");
	     scn = Scene();
         sel_Item = scn.getSelect();
	     sel_size = sel_Item.size();
	     linkto = sel_Item[sel_size];
	     SelectItem(sel_name+"_"+b_name[i]);
	     customshape(item, 6, 0, 0.03, 2, linkto);
		 
		 Skip_Num ++;
	    }
	 
	 nois = sel_name + "_Nois";
	 AddNull(nois);
	 ItemColor(1);
	 ItemLock(1);
     ItemVisibility(1);
	 ParentItem(name);
	 Position(0,0,0);
	 Rotation(0,0,0);
	 SchematicPosition((A_pos_x) , (-1.0+A_pos_y));

         qq="\"";
         ExpName = sel_name + "_Shake_X";
         ExpEquation = "["+sel_name+"_Shake.Position.X]* sin( 6.283 * Time *5*["+sel_name+"_Frequency.Position.X]-sin(Time*5)+random(0,(["+sel_name+"_Noise.Position.X]*5)))";
         CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
         CommandInput(CommandExec);
		 
         qq="\"";
         Tgt_Channnel = nois +".Position.X";
         CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel + qq + "" + qq + ExpName + qq);
         CommandInput(CommandExec);
		 
         qq="\"";
         ExpName = sel_name + "_Shake_Y";
         ExpEquation = "["+sel_name+"_Shake.Position.X]* sin( 6.283 * Time *5*["+sel_name+"_Frequency.Position.X]+(["+sel_name+"_Y.Position.X]*-sin(Time*10)+random(0,(["+sel_name+"_Noise.Position.X]*5))))*["+sel_name+"_Y.Position.X]";
         CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
         CommandInput(CommandExec);
		 
         qq="\"";
         Tgt_Channnel = nois +".Position.Y";
         CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel + qq + "" + qq + ExpName + qq);
         CommandInput(CommandExec);
	
	 pos = sel_name + "_Pos";
	 AddNull(pos);
	 ParentItem(nois);
	 Position(0,0,0);
	 Rotation(0,0,0);
	 SchematicPosition((A_pos_x) , (-0.6+A_pos_y));
	 
	 dof(var1, sel_name, camera, A_pos_x, A_pos_y);
	}
	if(var1 == 3)
	{
	 name = sel_name + "_base";
	 create_null(name, w_cam_position, w_cam_rotation);
	 SchematicPosition((A_pos_x) , (-2.4+A_pos_y));
	 ItemColor(1);
	 scn = Scene();
      sel_Item = scn.getSelect();
	  sel_size = sel_Item.size();
	  item = sel_Item[sel_size];
	 customshape(item, 6, 0, 0.5, 1, nil);
	
	 AddNull(sel_name + "_crane_Ht");
	 ParentItem(sel_name + "_base");
	 Position(0,1.8,0);
	 Rotation(0,0,0);
	 SchematicPosition((A_pos_x) , (-1.6+A_pos_y));
	 ItemColor(1);
	 MoveTool();
     EnableXH();
     EnableZB();
     RotateTool();
     EnableXH();
     EnableYP();
     EnableZB();
	 StretchTool();
	 EnableXH();
     EnableYP();
     EnableZB();
	 scn = Scene();
      sel_Item = scn.getSelect();
	  sel_size = sel_Item.size();
	  item = sel_Item[sel_size];
	 SelectItem(sel_name + "_base");
	 scn = Scene();
      sel_Item = scn.getSelect();
	  sel_size = sel_Item.size();
	  linkto = sel_Item[sel_size];
	 SelectItem(sel_name + "_crane_Ht");
	 customshape(item, 1, 1, 0.075, 1, linkto);
	
	 AddNull(sel_name + "_crane_Ht_Rot");
	 ParentItem(sel_name + "_crane_Ht");
	 Position(0,0,0);
	 Rotation(0,0,0);
	 SchematicPosition((A_pos_x) , (-1.2+A_pos_y));
	 ItemColor(12);
	 MoveTool();
     EnableXH();
     EnableYP();
     EnableZB();
     RotateTool();
     EnableZB();
     StretchTool();
	 EnableXH();
     EnableYP();
     EnableZB();
	 scn = Scene();
      sel_Item = scn.getSelect();
	  sel_size = sel_Item.size();
	  item = sel_Item[sel_size];
	 customshape(item, 6, 0, 0.15, 0, nil);
	
	 AddNull(sel_name + "_crane_Rot");
	 ParentItem(sel_name + "_crane_Ht_Rot");
	 Position(-0.35,0,0);
	 Rotation(0,0,0);
	 SchematicPosition((-1.6+A_pos_x) , (-1.2+A_pos_y));
	 ItemColor(13);
	 MoveTool();
     EnableXH();
     EnableYP();
     EnableZB();
     StretchTool();
	 EnableXH();
     EnableYP();
     EnableZB();
     scn = Scene();
      sel_Item = scn.getSelect();
	  sel_size = sel_Item.size();
	  item = sel_Item[sel_size];
	 SelectItem(sel_name + "_crane_Ht_Rot");
	 scn = Scene();
      sel_Item = scn.getSelect();
	  sel_size = sel_Item.size();
	  linkto = sel_Item[sel_size];
	 SelectItem(sel_name + "_crane_Rot");
	 customshape(item, 2, 0, 0.1, 1, linkto);
	
     AddNull(sel_name + "_Pos");
	 ParentItem(sel_name + "_crane_Ht_Rot");
	 Position(0,0,2);
	 Rotation(0,0,0);
	 SchematicPosition((A_pos_x) , (-0.8+A_pos_y));
	 ItemColor(1);
	 MoveTool();
     EnableXH();
     EnableYP();
     RotateTool();
	 EnableXH();
     EnableYP();
     EnableZB();
	 StretchTool();
	 EnableXH();
     EnableYP();
     EnableZB();
     scn = Scene();
      sel_Item = scn.getSelect();
	  sel_size = sel_Item.size();
	  item = sel_Item[sel_size];
	 SelectItem(sel_name + "_crane_Ht_Rot");
	 scn = Scene();
      sel_Item = scn.getSelect();
	 sel_size = sel_Item.size();
	 linkto = sel_Item[sel_size];
	 SelectItem(sel_name + "_Pos");
	 customshape(item, 1, 1, 0.075, 1, linkto);
	 RotationItem(sel_name + "_crane_Rot");
	 HController(7);
	 PController(7);
	 BController(7);
     
	 dof(var1, sel_name, camera, A_pos_x, A_pos_y);
	}
}
Oscillator
{
}
dof: var1, sel_name, camera, A_pos_x, A_pos_y
{
	 //DOF
	 SelectItem(camera.name);
	 CommandInput("AddEnvelope ZoomFactor");
	 ItemProperties();
	 ItemProperties();
	 DepthOfField();
	 CommandInput("AddEnvelope FocalDistance");
	 CommandInput("AddEnvelope FStop");
	    if(var1 != 1)
	    {
		 ParentItem(sel_name + "_Pos");
	     Position(0,0,0);
	     Rotation(0,0,0);
	    }
	 f_stop = sel_name + "_F";
	 AddNull(f_stop);
	 SchematicPosition(A_pos_x , (1.0+A_pos_y));
	 ItemColor(10);
	 ParentItem(camera.name);
	 Position(0,0.58,0);
	 Rotation(0,0,0);
	 Scale(4,1,1);
	 LimitSX();
	 SXLimits(0.1,30.0);
     s_scale();
	 SelectItem(camera.name);
	 
         qq="\"";
         ExpName = f_stop;
         ExpEquation = "["+ f_stop +".Scale.X]";
         CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
         CommandInput(CommandExec);
         qq="\"";
         Tgt_Channnel = camera.name +".FStop";
         CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel + qq + "" + qq + ExpName + qq);
         CommandInput(CommandExec);
	 
	 zmfc = sel_name + "_ZF";
     AddNull(zmfc);
	 SchematicPosition(A_pos_x , (0.4+A_pos_y));
     ItemColor(9);
	 ParentItem(camera.name);
	 Position(0,0,0.21);
	 Rotation(0,0,0);
	 Scale(0.24,0.24,0);
	 LimitSX();
	 SXLimits(0.06,2.5);
	 scn = Scene();
     sel_Item = scn.getSelect();
	 sel_size = sel_Item.size();
	 item = sel_Item[sel_size];
	 customshape(item, 6, 0, 1.0, 2, nil);
	 s_scale();
	 SelectItem(camera.name);
	 
         qq="\"";
   	     ExpName_zm = zmfc + "_zm";
	     ExpEquation_zm = "["+ zmfc +".Scale.X]*13.33";
         CommandExec_zm = ("GE_CreateExpression "+ qq + ExpName_zm + qq + " " + qq + ExpEquation_zm +qq);
         CommandInput(CommandExec_zm);
		 
	     qq="\"";
	     Tgt_Channnel_zm = camera.name +".ZoomFactor";
         CommandExec_zm = ("GE_AttachExpression "+ qq + Tgt_Channnel_zm + qq + "" + qq + ExpName_zm + qq);
         CommandInput(CommandExec_zm);
		 
         qq="\"";
   	     ExpName_fol = zmfc + "_fol";
	     ExpEquation_fol = "["+ zmfc +".Scale.X]";
         CommandExec_fol = ("GE_CreateExpression "+ qq + ExpName_fol + qq + " " + qq + ExpEquation_fol +qq);
         CommandInput(CommandExec_fol);
	 
	     qq="\"";
	     Tgt_Channnel_fol = zmfc +".Scale.Y";
         CommandExec_fol = ("GE_AttachExpression "+ qq + Tgt_Channnel_fol + qq + "" + qq + ExpName_fol + qq);
         CommandInput(CommandExec_fol);
		 
	 focaldistance = sel_name + "_FD";
	 AddNull(focaldistance);
	 ApplyServer("CustomObjHandler","LW_RangeFinder");
	 SchematicPosition((-1.6+A_pos_x) , (A_pos_y));
	 ItemColor(14);
	 ParentItem(camera.name);
	 Position(0,0,3);
	 Rotation(0,0,0);
	 MoveTool();
	 EnableXH();
	 EnableYP();
	 RotateTool();
	 EnableXH();
     EnableYP();
     EnableZB();
	 StretchTool();
	 EnableXH();
     EnableYP();
     EnableZB();
	 SelectItem(camera.name);
	 
         qq="\"";
   	     ExpName = focaldistance + "_fd";
	     ExpEquation = "["+ focaldistance +".Position.Z]";
         CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
         CommandInput(CommandExec);
	 
	     qq="\"";
	     Tgt_Channnel = camera.name +".FocalDistance";
         CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel + qq + "" + qq + ExpName + qq);
         CommandInput(CommandExec);
	 SelectItem(focaldistance);
	 MoveTool();
	 EditServer("CustomObjHandler",1);
}
create_null: name, w_cam_position, w_cam_rotation
{
  AddNull(name);
  Position(w_cam_position);
  Rotation(w_cam_rotation);
}
s_scale
{
  MoveTool();
  EnableXH();
  EnableYP();
  EnableZB();
  RotateTool();
  EnableXH();
  EnableYP();
  EnableZB();
  StretchTool();
  EnableYP();
  EnableZB();
}
customshape: item, shape, fill, scale, axis, linkto
{
    ApplyServer("CustomObjHandler","LW_ItemShape");
	
    ItemShapeData = itemshapedata();
	
    comringattach("ItemShapeComRing", "shapecomring");
    datablob = comringencode(ItemShapeData,
                                0,
                                item.id, 0,
                                0.0, 0.0, 0.0,
                                0, 0, 0, 0, 0,
                                0.0, 0.0, 0.0,
                                0.0, 0.0, 0.0,
                                0.0, 0.0, 0.0,
                                0.0, 0.0, 0.0,
                                "",
                                "",
                                "",
                                0,
                                "",
                                "",
                                0);
								
    comringmsg("ItemShapeComRing", 100, datablob);
    itemshape = comringdecode(ItemShapeData, datablob);
    if(linkto != nil)
        itemshape[3] = linkto.id;   // linkto
    itemshape[6] = scale;           // scale
    itemshape[7] = axis;            // axis
	itemshape[8] = fill;            //fill
    itemshape[10] = shape;          // shape
    if(linkto != nil)
        itemshape[29] = linkto.name;    // linktoname
    datablob = comringencode(ItemShapeData,
                                itemshape[1],
                                itemshape[2], itemshape[3],
                                itemshape[4],itemshape[5],itemshape[6],
                                itemshape[7],itemshape[8],itemshape[9],itemshape[10],itemshape[11],
                                itemshape[12],itemshape[13],itemshape[14],
                                itemshape[15],itemshape[16],itemshape[17],
                                itemshape[18],itemshape[19],itemshape[20],
                                itemshape[21],itemshape[22],itemshape[23],
                                itemshape[24],
                                itemshape[25],
                                itemshape[26],
                                itemshape[27],
                                itemshape[28],
                                itemshape[29],
                                itemshape[30]);
    comringmsg("ItemShapeComRing", 200, datablob);
    comringdetach("ItemShapeComRing");
}
shapecomring: code, data
{
}