/*
  LScript Layout
  SchemaPos_ds
  V1.3
  Daisuke Suzuki
  History: 2015/03/06
*/

//-----------------------------------------

@name SchemaPos_ds
@script generic
@version 2.3
@warnings

scn;
hierarchyList;
x = 0;

generic
{
scn = Scene();
sel_Item = scn.getSelect();
sel_size = sel_Item.size();
sel = sel_Item[sel_size];
A_pos = scn.schemaPosition(sel.name);

	if(sel_size == nil){
		error("Please select the item.");
		return;
	}
	if(sel_size == 1){
	    C_pos_x = A_pos[1];
	    C_pos_y = A_pos[2];
	}
	if(sel_size == 2){
        A_pos_x = A_pos[1];
        A_pos_y = A_pos[2];
        B_pos = scn.schemaPosition(sel_Item[1].name);
        B_pos_x = B_pos[1];
        B_pos_y = B_pos[2];
        C_pos_x = B_pos_x - ( A_pos_x);
        C_pos_y = B_pos_y - ( A_pos_y);
	}
	if(sel_size >= 3){
		error("Please select the item 1 or 2.");
		return;
	}

	var1 = false;
    xy = false;
	var	tchnm = recall( "center_Itm", nil ) ;
	var2 = false;

	reqbegin("SchemaPos_ds");
	reqsize(224,150);
	
	s0 = ctlsep(0,223);
    ctlposition(s0,0,56);
	c0 = ctltext("",sel_Item[1].name);
	ctlposition(c0,7,3);
	c1 = ctlnumber("X :",C_pos_x);
	ctlposition(c1,10,28,90);
	c2 = ctlnumber("Y :",C_pos_y);
	ctlposition(c2,115,28,90);
	c3 = ctlcheckbox("Symmetry",var1);
    ctlposition(c3,10,68,100);
	c4 = ctlchoice("",xy,@"X","Y"@);
    ctlposition(c4,109,68,102);
	c5 = ctlallitems("Center",tchnm);
    ctlposition(c5,95,90,116);
	c6 = ctlcheckbox("Hierarchy",var2);
    ctlposition(c6,10,90,80);

	ctlactive(c3,"scm_mirr_ac",c4,c5,c6);
	ctlactive(c3,"scm_mirr_ac2",c0,c1,c2);
	
	return if !reqpost();

	C_pos_x = getvalue(c1);
	C_pos_y = getvalue(c2);
    var1 = getvalue(c3);
	xy = getvalue(c4);
	tchnm = getvalue(c5);
	var2 = getvalue(c6);

	reqend();

//-----------------------------------------

 if(!var1){
    if(sel_size == 1){
       SchematicPosition(C_pos_x , C_pos_y);
	}
	if(sel_size == 2){
	   SelectItem(sel_Item[1].id);
	   SchematicPosition(A_pos_x +(C_pos_x) , A_pos_y +(C_pos_y));
	   sel_reset(sel_Item, sel_size);
	}
 }
 if(var1){
    if(tchnm == nil){
	  error("Please select the center item.");
	  return;
    }
	  SelectItem(tchnm.id);
      cnt_pos = scn.schemaPosition(tchnm.name);
      cnt_pos_x = cnt_pos[1];
      cnt_pos_y = cnt_pos[2];
	  
      SelectItem(sel_Item[2].id);
	  if(var2 == true)
	  sel_children();
	  tgt_Item = scn.getSelect();
	  tgt_size = tgt_Item.size();
	  SelectItem(sel_Item[1].id);
	  if(var2 == true)
	  sel_children();
	  mir_Item = scn.getSelect();
	  mir_size = tgt_Item.size();

      for(i = tgt_size ; i >= 1 ; i --){
		  SelectItem(mir_Item[i].id);
          SchematicPosition(0.0 , 0.0);
          tgt_pos = scn.schemaPosition(tgt_Item[i].name);
          tgt_pos_x = tgt_pos[1];
          tgt_pos_y = tgt_pos[2];
          SelectItem(mir_Item[i].id);
          if(xy == 1)
          SchematicPosition(cnt_pos_x-tgt_pos_x+cnt_pos_x , tgt_pos_y);
          else
          SchematicPosition( tgt_pos_x , cnt_pos_y-tgt_pos_y+cnt_pos_y);
	    }
 sel_reset(sel_Item, sel_size);
 tchnm = tchnm.name;
 store( "center_Itm", tchnm );
 }
}
sel_children
{
    firstObj = true;
    firstBone = true;
    firstLight = true;
    firstCamera = true;

    (curItem) = scn.getSelect();

    findChildren(curItem);

    for(a = 1; a <= x;a++)
        idList[a] = hierarchyList[a].id;

    for(y = 1;y <= x;y++){
        if((itemType = hierarchyList[y].genus) == MESH){
            EditObjects();
            if(firstObj){
                SelectItem(hierarchyList[y].id);
                firstObj = false;
            }
            else
                AddToSelection(hierarchyList[y].id);
        }     
        else if((itemType = hierarchyList[y].genus) == BONE){
            EditBones();

            if(firstBone){
                SelectItem(hierarchyList[y].id);
                firstBone = false;
            }
            else
                AddToSelection(hierarchyList[y].id);
        }
        else if((itemType = hierarchyList[y].genus) == LIGHT){
            EditLights();
            if(firstLight){
                SelectItem(hierarchyList[y].id);
                firstLight = false;
            }
            else
                AddToSelection(hierarchyList[y].id);
        }
        else{
            EditCameras();
            if(firstCamera){
                SelectItem(hierarchyList[y].id);
                firstCamera = false;
            }
            else
                AddToSelection(hierarchyList[y].id);
        }
    }
}
findChildren: rootObj
{
  hierarchyList[++x] = rootObj;
  childObj = rootObj.firstChild();
  while(childObj){
      findChildren(childObj);
	  childObj = rootObj.nextChild();
    }
}
sel_reset: sel_item, sel_size
{
	for(i = sel_size ; i >= 1 ; i --){
		if(i == sel_size){
			sel_id = sel_item[sel_size].id;
			SelectItem(sel_id);
		}
		else{
			sel_id = sel_item[i].id;
			AddToSelection(sel_id);
		}
	}
}
scm_mirr_ac: value
{
  return(value==true);
}
scm_mirr_ac2: value
{
  return(value==false);
}