/*
  LScript Layout
  BoxRig_ds
  V1.0
  Daisuke Suzuki
  History: 2015/01/08
*/

//-----------------------------------------

@version 2.6
@warnings
@script generic
@name BoxRig_ds


generic
{
    scn = Scene();
    seled_Item = scn.getSelect();
	sel_count = seled_Item.count();
	
	if(sel_count == 0)
    {
	  error("Please select the object.");
	  return;
    }
	
	sel_size = seled_Item.size();
	sel_Item_name = seled_Item[sel_size].name;
	A_pos = scn.schemaPosition(sel_Item_name);
	A_pos_x = A_pos[1];
    A_pos_y = A_pos[2];
	
	
    Un_b ="Under_box";
    UP_b ="UP_box";
	Rt_b ="Right_box";
	Lt_b ="Left_box";
  
    var1 = false;
	var2 = "_";
	
	reqbegin("BoxRig_ds");
	reqsize(210,90);
	
	c1 = ctlchoice("",var1,@"1.Generate Null","2.Box Setup"@);
    ctlposition(c1,10,12);
	
	c2 = ctlstring("Suffix Name :",var2);//Name
    ctlposition(c2,15,34);
	
	ctlactive(c1,"LC1",c2);
	
	
	return if !reqpost();
	
	var1 = getvalue(c1);
	var2 = getvalue(c2);
	
	reqend();
	
	
	if(var1 == 1)
	{
      sc1 = true;
    }
    if(var1 == 2)
	{
      sc2 = true;
    }

//-----------------------------------------
if(sc1)
    {
      AddNull(Un_b);
	  ItemColor(12);
	  Position(0,-0.01,0);
	  SchematicPosition( 2.5 + A_pos_x ,-0.4 + A_pos_y);
	  AddNull(UP_b);
	  ItemColor(10);
	  SchematicPosition( 2.5 + A_pos_x ,0.4 + A_pos_y);
	  PositionItem(Un_b);
	  YController(7);
	  YTransform(-1,0);
	  
	  AddNull(Rt_b);
	  ItemColor(5);
	  Position(-0.05,0,0);
	  SchematicPosition( 1.5 + A_pos_x ,A_pos_y);
	  AddNull(Lt_b);
	  ItemColor(3);
	  SchematicPosition( 3.5 + A_pos_x ,A_pos_y);
	  PositionItem(Rt_b);
	  XController(7);
	  XTransform(-1,0);
	  YController(7);
	  YTransform(1,0);
	  
	  SelectByName(Un_b);
    }
	
	
if(sc2)
    {
	    if(Un_b == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the coin object.");
	     return;
        }
		if(UP_b == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the coin object.");
	     return;
        }
		if(Rt_b == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the coin object.");
	     return;
        }
		if(Lt_b == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the coin object.");
	     return;
        }
		
	    SelectByName(UP_b);
		CreateKey(0);
		scn = Scene();
        sel_Itemh = scn.getSelect();
	    Height_pos = sel_Itemh[1].getPosition(0).y;
		
	    SelectByName(Lt_b);
		CreateKey(0);
		scn = Scene();
        sel_Itemw = scn.getSelect();
	    Wide_pos = sel_Itemw[1].getPosition(0).x;
        Spe_pos = round(Wide_pos * 2,3);
		Spe_pos_b = round(Wide_pos / 3,3);
		
		Master_b = "Master"+var2;
		AddNull(Master_b);
		ItemColor(1);
		customshape(item_name, 6, 0, Spe_pos, 1, nil);
		SchematicPosition(-1.2+A_pos_x ,-1.0 + A_pos_y);
		
		ctrl_b_none = "ctrl_none"+var2;
		AddNull(ctrl_b_none);
		ItemVisibility(1);
	    ItemColor(8);
		SchematicPosition(-2.4+A_pos_x ,-0.4 + A_pos_y);
		
		ParentItem(Master_b);
		Position(0,Height_pos*4,0);
		
		ctrl_b = "CTRL"+var2;
		AddNull(ctrl_b);
	    ItemColor(14);
		customshape(item_name, 2, 0, Spe_pos_b, 1, nil);
		SchematicPosition(-2.4 + A_pos_x ,A_pos_y);
		ParentItem(ctrl_b_none);
		Position(0,0,0);
		
		amp_b = "Amplitude"+var2;
		AddNull(amp_b);
	    ItemColor(13);
		SchematicPosition(-1.2 + A_pos_x ,A_pos_y);
		ParentItem(ctrl_b);
		Position(Wide_pos*0.8,Height_pos/5,0);
		s_scale();
		
		amp_ht_b = "Amp_Ht"+var2;
		AddNull(amp_ht_b);
	    ItemColor(9);
		SchematicPosition(-1.2 + A_pos_x ,-0.4+A_pos_y);
		ParentItem(ctrl_b);
		Position(Wide_pos*0.8,-Height_pos/5,0);
		s_scale();
		
		h_box = "Height"+var2;
		AddNull(h_box);
		ItemVisibility(1);
		SchematicPosition(A_pos_x ,-0.4 + A_pos_y);
		ParentItem(Master_b);
		Position(0,Wide_pos,0);
		
		Move = "X";
		bp_p = (Height_pos*Height_pos)+(Wide_pos*Wide_pos);
	    bp = sqrt(bp_p);
		Expr_pos(sel_Item_name, bp, ctrl_b, Move);
		
		Move = "Y";
		ippen = Height_pos*2;
		baisu = 1/ippen;
		amp_defHT =4.8*baisu;
		Expr_pos_y(sel_Item_name, ctrl_b, Move, amp_defHT, amp_b, amp_ht_b);
		
		Move = "Z";
		Expr_pos(sel_Item_name, bp, ctrl_b, Move);
		
        Rotate = "P";
		pramai = "";
		Move = "Z";
		Expr_rot(sel_Item_name, pramai, ctrl_b, Move, Rotate);
		
		Rotate = "B";
		pramai = "-";
		Move = "X";
		Expr_rot(sel_Item_name, pramai, ctrl_b, Move, Rotate);
		
		
		SelectByName(sel_Item_name);
		ParentItem(h_box);
		Position(0,0,0);
		
		
		SelectByName(Un_b);
		AddToSelection(UP_b);
		AddToSelection(Rt_b);
		AddToSelection(Lt_b);
		ClearSelected(1);
		
		SelectByName(ctrl_b);
		RotateTool();
    }
}

Expr_pos: sel_Item_name, bp, ctrl_b, Move
{
	       obj = Mesh();
		   
           qq="\"";
           ExpName = sel_Item_name + var2 + "_" + Move;
	       ExpEquation = "(["+ ctrl_b +".Position."+ Move +"]*"+ bp +")*["+ ctrl_b +".Scale."+ Move +"]";
           CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
           CommandInput(CommandExec);
		   
		   qq="\"";
	       Channnel_Expr_B = sel_Item_name + ".Position."+ Move;
	       CommandExec_B = ("GE_AttachExpression "+ qq + Channnel_Expr_B + qq + "" + qq + ExpName + qq);
           CommandInput(CommandExec_B);
}

Expr_pos_y: sel_Item_name, ctrl_b, Move, amp_defHT, amp_b, amp_ht_b
{
	       obj = Mesh();
		   
           qq="\"";
           ExpName = sel_Item_name + var2 + "_" + Move;
	       ExpEquation = "abs(sin((["+ctrl_b+".Position.Z]+["+ctrl_b+".Position.X])*(2*["+amp_b+".Scale.X]))/("+amp_defHT+"*["+amp_ht_b+".Scale.X]))*["+ctrl_b+".Scale.Y]";
           CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
           CommandInput(CommandExec);
		   
		   qq="\"";
	       Channnel_Expr_B = sel_Item_name + ".Position."+ Move;
	       CommandExec_B = ("GE_AttachExpression "+ qq + Channnel_Expr_B + qq + "" + qq + ExpName + qq);
           CommandInput(CommandExec_B);
}

Expr_rot: sel_Item_name, pramai, ctrl_b, Move, Rotate
{
	       obj = Mesh();
		   
           qq="\"";
           ExpName = sel_Item_name + var2 + "_" + Rotate;
	       ExpEquation = pramai + "deg([" + ctrl_b + ".Position."+ Move +"])";
           CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
           CommandInput(CommandExec);
		   
		   qq="\"";
	       Channnel_Expr_B = sel_Item_name + ".Rotation."+ Rotate;
	       CommandExec_B = ("GE_AttachExpression "+ qq + Channnel_Expr_B + qq + "" + qq + ExpName + qq);
           CommandInput(CommandExec_B);
}

LC1: value
{
  return(value==2);
}
s_scale
{
  MoveTool();
  EnableXH();
  EnableYP();
  EnableZB();
  RotateTool();
  EnableXH();
  EnableYP();
  EnableZB();
  StretchTool();
  EnableYP();
  EnableZB();
}
customshape: item, shape, fill, scale, axis, linkto
{
 sel_item = Scene().getSelect();
 item_size = sel_item.size();
 item = sel_item[item_size].id;

    SelectItem(item);
    ApplyServer("CustomObjHandler","LW_ItemShape");
	
    ItemShapeData = itemshapedata();
	
    comringattach("ItemShapeComRing", "shapecomring");
    datablob = comringencode(ItemShapeData,
                                0,
                                item, 0,
                                0.0, 0.0, 0.0,
                                0, 0, 0, 0, 0,
                                0.0, 0.0, 0.0,
                                0.0, 0.0, 0.0,
                                0.0, 0.0, 0.0,
                                0.0, 0.0, 0.0,
                                "",
                                "",
                                "",
                                0,
                                "",
                                "",
                                0);
								
    comringmsg("ItemShapeComRing", 100, datablob);
    itemshape = comringdecode(ItemShapeData, datablob);
    if(linkto != nil)
        itemshape[3] = linkto.id;   // linkto
    itemshape[6] = scale;           // scale
    itemshape[7] = axis;            // axis
	itemshape[8] = fill;            //fill
    itemshape[10] = shape;          // shape
    if(linkto != nil)
        itemshape[29] = linkto.name;    // linktoname
    datablob = comringencode(ItemShapeData,
                                itemshape[1],
                                itemshape[2], itemshape[3],
                                itemshape[4],itemshape[5],itemshape[6],
                                itemshape[7],itemshape[8],itemshape[9],itemshape[10],itemshape[11],
                                itemshape[12],itemshape[13],itemshape[14],
                                itemshape[15],itemshape[16],itemshape[17],
                                itemshape[18],itemshape[19],itemshape[20],
                                itemshape[21],itemshape[22],itemshape[23],
                                itemshape[24],
                                itemshape[25],
                                itemshape[26],
                                itemshape[27],
                                itemshape[28],
                                itemshape[29],
                                itemshape[30]);
    comringmsg("ItemShapeComRing", 200, datablob);
    comringdetach("ItemShapeComRing");
}
shapecomring: code, data
{
}