/*
  LScript Layout
  SelBoneTgtRot_ds
  V1.6
  Daisuke Suzuki
  History: 2017/10/23
*/

//-----------------------------------------

@name SelBoneTgtRot_ds
@script generic
@version 2.3
@warnings


generic
{
    var1 = false;
    var2 = false;
	var3 = false;
	var4 = false;

	
    reqbegin("SelBoneTgtRot_ds");
    reqsize(200,90);
	

	    c1 = ctlchoice("",var1,@"+","-"@);
    ctlposition(c1,25,10,40,16);
	
	    c2 = ctlchoice("tgt",var2,@"X","Y","Z"@);
    ctlposition(c2,10,30);
	
	    c3 = ctlchoice("",var3,@"+","-"@);
    ctlposition(c3,122,10,40,16);
	
	    c4 = ctlchoice("pole",var4,@"X","Y","Z"@);
    ctlposition(c4,100,30);



    return if !reqpost();

    var1 = getvalue(c1);
    var2 = getvalue(c2);
    var3 = getvalue(c3);
    var4 = getvalue(c4);

	reqend();
	

    if(var1 == 1)//tgt_hoko
	{
      t_hoko = 1.0;
    }
    if(var1 == 2)
	{
      t_hoko = -1.0;
    }
    if(var2 == 1)//tgt
	{
      tgt_x = 1.0;
      tgt_y = 0;
      tgt_z = 0;
    }
    if(var2 == 2)
	{
      tgt_x = 0;
      tgt_y = 1.0;
      tgt_z = 0;
    }
    if(var2 == 3)
	{
      tgt_x = 0;
      tgt_y = 0;
      tgt_z = 1.0;
    }
    if(var3 == 1)//pole_hoko
	{
      p_hoko = 1.0;
    }
    if(var3 == 2)
	{
      p_hoko = -1.0;
    }
    if(var4 == 1)//pole
	{
      pole_x = 1.0;
      pole_y = 0;
	  pole_z = 0;
    }
    if(var4 == 2)
	{
      pole_x = 0;
      pole_y = 1.0;
	  pole_z = 0;
    }
    if(var4 == 3)
	{
      pole_x = 0;
	  pole_y = 0;
	  pole_z = 1.0;
    }


//----------------------------------

  d_tgt = "dummy_tgt";
  d_upv = "dummy_upv";

  scn = Scene();
  fps = scn.fps;
  ImaTime = scn.currenttime;
       selected_bone = scn.getSelect();
	   sel_size = selected_bone.size();
       //bone_position = selected_bone[1].getWorldPosition(ImaTime);
	   
	   for(i = sel_size ; i >= 1 ; i --)
	   {
	    
	    //tgt
	    tgtItem(d_tgt,selected_bone[i].getWorldPosition(ImaTime),t_hoko,tgt_x,tgt_y,tgt_z);

        //upv
	    tgtItem(d_upv,selected_bone[i].getWorldPosition(ImaTime),p_hoko,pole_x,pole_y,pole_z);
        SelectItem(selected_bone[i].id);
	    option(d_tgt,d_upv,2,2,6);
	    RefreshNow();
        CreateKey(ImaTime);
	    option(0,0,1,1,1);

	    CommandInput("EnableIK");
	    clear(d_tgt);
	    clear(d_upv);

		}
	sel_reset(selected_bone, sel_size);
}
tgtItem: ItemName, PosItem, hoko, t_x, t_y, t_z
{
    AddNull(ItemName);
	ItemVisibility(VIS_VISIBLE);
    Position(PosItem);
	target_x = hoko*t_x;
	target_y = hoko*t_y;
	target_z = hoko*t_z;
	AddPosition(target_x,target_y,target_z);
}
option: tgtname, upvname , Hcon, Pcon, Bcon
{
    TargetItem(tgtname);
	PoleItem(upvname);
    HController(Hcon);
    PController(Pcon);
	BController(Bcon);
}
clear: clrname
{
    SelectItem(clrname);
    ClearSelected(1);
}
sel_reset: sel_item, sel_size
{
	for(i = sel_size ; i >= 1 ; i --){
		if(i == sel_size){
			sel_id = sel_item[sel_size].id;
			SelectItem(sel_id);
		}
		else{
			sel_id = sel_item[i].id;
			AddToSelection(sel_id);
		}
	}
}