/*
  LScript Layout
  Legacy_LightIntensity
  LW2018
  V1.1
  Daisuke Suzuki
  History: 2018/08/28  V1.2
           2018/07/26  V1.1
           2018/02/24  V1.0
*/

//-----------------------------------------

@version 2.7
@warnings
@script master
@name LegacyLI_ds

scn;
text_sel;
get_LI;
sav_LI;
initialIntensity;
c0;
c1;
var c2;
var v2;
var3;
ca;

create
{
    scn = Scene();
    getSelected();
	sav_LI = nil;
}

flags
{
  return(SCENE);
}

process: event, command
{

   if(command != null)
   {
   
        command = parse(" ", command);
        if(event == COMMAND)
		{
		    
            if(command[1] == "SelectItem" or
            command[1] == "AddToSelection" or
            command[1] == "RemoveFromSelection")
			{
			    LightID = command[2];
                getSelected();
                lux = nil;
		        initialIntensity = nil;
				
	            if(reqisopen())
				{
				    setvalue(c0,text_sel);
					
					setvalue(c2,get_LI);
                    requpdate();
					//get_LI = nil;
				}
            }
			else
			{
			    if(reqisopen())
				{
				ctlrefresh(c2,"CtlCallBack1");
				requpdate();
				}
			}
        }
	}
}

options
{
    if(reqisopen())
    reqend();
    else
    {
	　　　choice_a[1] = "Basic  3.14";
	    choice_a[2] = "Dome  1.57";
	    choice_a[3] = "Spherical  6.28";

		if( text_sel== nil)
        {
	        error("Please select the light.");
	        return;
        }
	    var3 = 1;
		reqbegin("LegacyLI_ds");
		reqsize(210,80);
		
		c0 = ctltext("",text_sel);
		ctlposition(c0,7,3);
		
		c1 = ctlpopup("Light Type",var3,choice_a);ctlposition(c1,15,26,180);
		
		c2 = ctlpercent("Light Intensity",get_LI);
        ctlposition(c2,15,48,158);
		
		reqopen();
	}
}
CtlCallBack1: v1
{
    v1 = getvalue(c2);//a

	var3 = getvalue(c1);
	    if(var3 == nil)
		{
		    lux = v1 * 3.14;
		}
		
		else
		{
		    switch(var3)
		    {
		      case 1:
			  lux = v1 * 3.14;
			  break;
		      case 2:
			  lux = v1 * 1.57;
			  break;
			  case 3:
			  lux = v1 * 6.28;
			  break;
		    }
        }

	if(lux != initialIntensity)
	{
	
    scn = Scene();
        Sel_Item = scn.getSelect();
        Sel_Cnt = Sel_Item.count();
        Sel_Gns = Sel_Item[Sel_Cnt].genus;
  
        if(Sel_Gns != 2)
        {
	        error("Please select the light.");
	        return;
        }
		//SelectItem(Sel_Item[1].name);
		//info("Output " + lux);
	    LightIntensity(lux);
		
	}
    //info(v1);
	//lux = 3.14*var1;
	
	/*
	for(i =1 ; i <= Sel_Cnt ; i++)
	{
	    SelectItem(Sel_Item[i].name);
	    LightIntensity(p_val);
	}
	*/
	
	/*
	SelectItem(Sel_Item[Sel_Cnt].id); //sel_modosu
		    for(i =1 ; i < Sel_Cnt ; i++)
	        {
		        AddToSelection(Sel_Item[i].id);
		    }
			*/
			//info(get_LI);
			
}

getSelected
{
    scn = Scene();
    sel_Item = scn.getSelect();
    sel_size = sel_Item.size();
	
	if(sel_Item == nil)
    {
	  error("Please select the Light.");
	  return;
    }
	sel = sel_Item[sel_size];
	Sel_Gnus = sel.genus;
	if(Sel_Gnus != 2)
    {
	  error("Please select the Light.");
	  return;
    }
	if(sel_size != 1)
    {
	  error("Please select the 1 item.");
	  return;
    }
	if(Sel_Gnus==2)
	{

		lgt = Light(sel.name);
	    curtime = scn.currenttime;
		ca = lgt.color(curtime).x;


        if(var3==nil)
		{
		initialIntensity = (ca / 3.14);
		}
		/*
		else
		{
		    var3 = getvalue(c1);
            if(var3==1)
		    {
		    initialIntensity = (ca / 3.14);
		    }
		    if(var3==2)
		    {
		    initialIntensity = (ca / 1.57);
		    }
		    if(var3==3)
		    {
		    initialIntensity = (ca / 6.28);
		    }
		}
		*/
		else
		{
		    var3 = getvalue(c1);
		    switch(var3)
		    {
		      case 1:
			  initialIntensity = (ca / 3.14);
			  break;
		      case 2:
			  initialIntensity = (ca / 1.57);
			  break;
			  case 3:
			  initialIntensity = (ca / 6.28);
			  break;
		    }
        }

		lux = initialIntensity;//parcent

		
		get_LI = number(lux);
		
	}
    c0_name(sel_Item,sel_size);
}

c0_name:sel_Item,sel_size
{
    if(sel_size >=3)
	{
	   text_sel = sel_Item[sel_size].name + "  -> " + sel_Item[sel_size - 1].name + "  -> ++....";
	}
    if(sel_size ==2)
	{
	   text_sel = sel_Item[2].name + "  -> " + sel_Item[1].name;
	}
    if(sel_size ==1)
	{
	   text_sel = sel_Item[1].name;
	}
	   return(text_sel);
}