/*
  LScript Layout
  ChildScaleFix_ds
  V1.2
  Daisuke Suzuki
  History: 2021/03/14
*/
//問題：CSFの末端の子ボーンのリスケル
//-----------------------------------------

@version 2.6
@warnings
@script generic
@name ChildScaleFix_ds

c1;
c2;
var1;
var2;
BRLength;
dm_x;
dm_y;
dm_z;

generic
{
 var1 = 1;
 var2 = recall( "bc", 0 );
 var3 = 0;
 scn = Scene();
 sel_Item = scn.getSelect();
 sel_size = sel_Item.size();
 child = sel_Item[1].firstChild();
 sel_genus = sel_Item[sel_size].genus;
 cld_Num = sel_size - 1;
 cld_Num3 = sel_size - 1;
 cld_Num5 = sel_size - 1;
 G_Col = recall( "ge_col", 12 );
 C_Col = recall( "cl_col", 11 );
 
 choice4[1] = "Black";choice4[2] = "Dark Blue";choice4[3] = "Dark Green";choice4[4] = "Dark Cyan";choice4[5] = "Dark Red";
 choice4[6] = "Dark Magenta";choice4[7] = "Brown";choice4[8] = "Gray";choice4[9] = "Blue";choice4[10] = "Green";
 choice4[11] = "Cyan";choice4[12] = "Red";choice4[13] = "Magenta";choice4[14] = "Orange";choice4[15] = "White";

 ParentInPlace(true);
 
 reqbegin("ChildScaleFix2_ds");
 reqsize(220,126);
 
 c1 = ctlchoice("ChildScaleFix",var1,@"Generate","Clear"@);
 ctlposition(c1,10,10,200);
 c2 = ctlcheckbox("Bone Color",var2);
   ctlposition(c2,86,32,124);
 c3 = ctlpopup("Gn :",G_Col,choice4);
 ctlposition(c3,10,52,98);
 c4 = ctlpopup("Cl :",C_Col,choice4);
 ctlposition(c4,113,52,96);
 c5 = ctlcheckbox("GE_ClearUnusedExpressions",var3);
 ctlposition(c5,10,72,200);

 ctlactive(c2,"AC1",c3,c4);
 ctlactive(c1,"AC2",c5);
 
 
 return if !reqpost(); 
 
 var1 = getvalue(c1);
 var2 = getvalue(c2);
 G_Col = getvalue(c3);
 C_Col = getvalue(c4);
 var3 = getvalue(c5);
   
   reqend();
   
   if(var1 == 1)//Generate
   {
		for(i = sel_size ; 1 < i ; i --)
		{
            SelectItem(sel_Item[i].id);
			if(var2 == 1)
			{
			    ItemColor(G_Col);
			}
	        tgt_name = sel_Item[cld_Num].name;
	        CSF_name = tgt_name + "_csf";
	        AddChildBone(CSF_name);
	        BoneRestLength(0.001);
	        BoneStrength(0);
			ItemLock(1);
	        ItemVisibility(1);
	        ItemColor(1);
	        SelectItem(tgt_name);
	        RefreshNow();
	        ParentItem(CSF_name);
			if(var2 == 1)
			{
			    ItemColor(G_Col);
			}
	
	        ExpName_x = "SFC_" + tgt_name + "_"+ 1.asStr(2,true);
	        ExpName_y = "SFC_" + tgt_name + "_"+ 2.asStr(2,true);
	        ExpName_z = "SFC_" + tgt_name + "_"+ 3.asStr(2,true);

	        if(sel_genus == 4)//ボーンであるか
	        {
                obj = ChannelGroup(sel_Item[i].name).parent.name;
				ExpEquation_x = "exp( ( log([" + obj + "." + sel_Item[i].name +".Scale.X]) *-1) )";
	            Tgt_Channnel_x = obj + "."+ CSF_name +".Scale.X";
	            ExpEquation_y = "exp( ( log([" + obj + "." + sel_Item[i].name +".Scale.Y]) *-1) )";
	            Tgt_Channnel_y = obj + "."+ CSF_name +".Scale.Y";
	            ExpEquation_z = "exp( ( log([" + obj + "." + sel_Item[i].name +".Scale.Z]) *-1) )";
	            Tgt_Channnel_z = obj + "."+ CSF_name +".Scale.Z";
	        }
	        if(sel_genus != 4)//ボーンではないか
	        {
                ExpEquation_x = "exp( ( log([" + sel_Item[i].name +".Scale.X]) *-1) )";
	            Tgt_Channnel_x = CSF_name +".Scale.X";
	            ExpEquation_y = "exp( ( log([" + sel_Item[i].name +".Scale.Y]) *-1) )";
	            Tgt_Channnel_y = CSF_name +".Scale.Y";
	            ExpEquation_z = "exp( ( log([" + sel_Item[i].name +".Scale.Z]) *-1) )";
	            Tgt_Channnel_z = CSF_name +".Scale.Z";
	        }
	        Expr(1, ExpName_x, ExpEquation_x, Tgt_Channnel_x, var3);
	        Expr(1, ExpName_y, ExpEquation_y, Tgt_Channnel_y, var3);
	        Expr(1, ExpName_z, ExpEquation_z, Tgt_Channnel_z, var3);
	        cld_Num--;
	    }
	SelectItem(sel_Item[sel_size].id);
	store( "ge_col", G_Col );
	}
	else//Clear-------------------------------------------------------------------------------------------
	{
		//終端のボーンに、子ボーンが有るか否か
		
		cld = child;
		
		if( child == nil)//終端ボーンに子がいない場合、子ボーンを生成する。
		{
		    SelectItem(sel_Item[1].id);
			end_b = sel_Item[1].name + "_end";
			AddChildBone(end_b);
			for(i = sel_size ; 1 <= i ; i --)
		    {
		        if(i == sel_size)
		        {
			        sel_id = sel_Item[sel_size].id;
		            SelectItem(sel_id);
		        }
			    else
			    {
			        sel_id = sel_Item[i].id;
				    AddToSelection(sel_id);
			    }
			}
			AddToSelection(end_b);
			scn = Scene();//csfに関わるボーンの情報を取得
		    csf_Item = scn.getSelect();
		    csf_size = csf_Item.size();
		}
		else//終端ボーンに子がいる場合、子ボーンの情報を取得する。
		{
			SelectItem(child.id);
			done = false;
			while(!done)
			{
				if(cld == nil)
				{
					done = true;
				}
				else
				{
				    cld = sel_Item[1].nextChild(); 
				    if(cld != nil)
					{
					    AddToSelection(cld.id);
					}
				}
			}
			scn = Scene();//子ボーンの情報を取得
		    cds_Item = scn.getSelect();
		    cds_size = cds_Item.size();
			
			for(i = sel_size ; 1 <= i ; i --)
		    {
		        if(i == sel_size)
		        {
			        sel_id = sel_Item[sel_size].id;
		            SelectItem(sel_id);
		        }
			    else
			    {
			        sel_id = sel_Item[i].id;
				    AddToSelection(sel_id);
			    }
			}
			for(i = cds_size ; 1 <= i ; i --)
		    {
			    sel_id = cds_Item[i].id;
				AddToSelection(sel_id);
			}
			scn = Scene();//csfに関わるボーンの情報を取得
		    csf_Item = scn.getSelect();
		    csf_size = csf_Item.size();
		}
		
		csf_Num = sel_size - 1;
		for(i = sel_size ; 1 < i ; i --)//スケールのダミーボーン生成（ｄｍ）
	    {
			if(i == sel_size)
			{
				SelectItem(sel_Item[sel_size].id);
				dm = sel_Item[sel_size].name + "_dm";
				Clone(1);
				Rename(dm);
				Scale(1,1,1);
				localBRL_2(child, sel_Item, sel_size, 1);
				SelectItem(sel_Item[sel_size].id);
				dm_2 = sel_Item[csf_Num].name + "_dm";
				AddChildBone(dm_2);
				RefreshNow();
				ParentItem(dm);
				Scale(1,1,1);
				localBRL_2(child, sel_Item, csf_Num, 1);
			}
			else
			{
			    SelectItem(sel_Item[i].id);
				dm = sel_Item[csf_Num].name + "_dm";
				AddChildBone(dm);
				RefreshNow();
				dm_oya = sel_Item[i].name + "_dm";
				ParentItem(dm_oya);
				Scale(1,1,1);
				localBRL_2(child, sel_Item, csf_Num, 1);
			}
			csf_Num--;
		}
		end_b = sel_Item[1].name + "_end";
		if( child == nil)
		{
			AddChildBone(end_b + "_dm");
		}
		else
		{
		    for(i = cds_size ; 1 <= i ; i --)//スケールの終端ダミーボーン生成（ｄｍ）
	        {
			    SelectItem(sel_Item[1].id);
				dm = cds_Item[i].name + "_dm";
				AddChildBone(dm);
				Scale(1,1,1);
				RefreshNow();
				dm_oya = sel_Item[1].name + "_dm";
				ParentItem(dm_oya);
				
				localBRL_2(child, cds_Item, i, 1);
				AddChildBone(cds_Item[i].firstChild().name + "_dm");
			}
		}
		for(i = sel_size ; 1 < i ; i --)//csfのExpr除去　親子関係変更
		{
		    tgt_name = sel_Item[cld_Num].name;
	        CSF_name = tgt_name + "_csf";
			SelectItem(sel_Item[cld_Num].id);
		    RefreshNow();
			oya = sel_Item[sel_size].parent;
	        ParentItem(oya.id);
			
			ExpName_x = "SFC_" + tgt_name + "_"+ 1.asStr(2,true);
	        ExpName_y = "SFC_" + tgt_name + "_"+ 2.asStr(2,true);
	        ExpName_z = "SFC_" + tgt_name + "_"+ 3.asStr(2,true);
			
			if(sel_genus == 4)//ボーンであるか
	        {
			    obj = ChannelGroup(sel_Item[i].name).parent.name;
                ExpEquation_x = "exp( ( log([" + obj + "." + sel_Item[i].name +".Scale.X]) *-1) )";
	            Tgt_Channnel_x = obj + "."+ CSF_name +".Scale.X";
	            ExpEquation_y = "exp( ( log([" + obj + "." + sel_Item[i].name +".Scale.Y]) *-1) )";
	            Tgt_Channnel_y = obj + "."+ CSF_name +".Scale.Y";
	            ExpEquation_z = "exp( ( log([" + obj + "." + sel_Item[i].name +".Scale.Z]) *-1) )";
	            Tgt_Channnel_z = obj + "."+ CSF_name +".Scale.Z";
	        }
	        if(sel_genus != 4)//ボーンではないか
	        {
                ExpEquation_x = "exp( ( log([" + sel_Item[i].name +".Scale.X]) *-1) )";
	            Tgt_Channnel_x = CSF_name +".Scale.X";
	            ExpEquation_y = "exp( ( log([" + sel_Item[i].name +".Scale.Y]) *-1) )";
	            Tgt_Channnel_y = CSF_name +".Scale.Y";
	            ExpEquation_z = "exp( ( log([" + sel_Item[i].name +".Scale.Z]) *-1) )";
	            Tgt_Channnel_z = CSF_name +".Scale.Z";
	        }
	        Expr(2, ExpName_x, ExpEquation_x, Tgt_Channnel_x, var3);
	        Expr(2, ExpName_y, ExpEquation_y, Tgt_Channnel_y, var3);
	        Expr(2, ExpName_z, ExpEquation_z, Tgt_Channnel_z, var3);
			cld_Num--;
		}
		for(i = sel_size ; 1 < i ; i --)//CSF除去　
		{
		　　　if(i == sel_size)
		    {
			    sel_n = sel_Item[cld_Num3].name + "_csf";
		        SelectItem(sel_n);
		    }
			else
			{
			    sel_n = sel_Item[cld_Num3].name + "_csf";
				AddToSelection(sel_n);
			}
			cld_Num3--;
		}
		ClearSelected(1);
		for(i = sel_size ; 1 < i ; i --)//親子関係修正
		{
		    SelectItem(sel_Item[cld_Num5].id);
		    RefreshNow();
	        ParentItem(sel_Item[i].id);
			cld_Num5--;
		}
		for(i = csf_size ; 1 <= i ; i --)//ダミーボーンの情報取得
		{
		　　　if(i == csf_size)
		    {
			    dm = csf_Item[csf_size].name + "_dm";
		        SelectItem(dm);
		    }
			else
			{
			    dm = csf_Item[i].name + "_dm";
				AddToSelection(dm);
				if(i == 1)
				{
					if(child == nil)
					AddToSelection(end_b + "_dm");
				}
			}
		}
		scn = Scene();
		dm_Item = scn.getSelect();
		dm_size = dm_Item.size();
		for(i = dm_size ; 1 <= i ; i --)//スケール反映
		{
			itm = dm_Item[i].name - "_dm";
			SelectItem(itm);
			Scale(1, 1, 1);
			RefreshNow();
			CreateKey(0);
			SelectItem(dm_Item[i].name);
			scn = Scene();
		    dm_Item2 = scn.getSelect();
		    dm_size2 = dm_Item2.size();
			localBRL_2(child, dm_Item2, dm_size2, 0);	
		}
		dm = sel_Item[sel_size].name + "_dm";
		SelectItem(dm);
		CommandInput("Generic_selectchildren");
		scn = Scene();
		dm_Item = scn.getSelect();
		dm_size = dm_Item.size();
		
		for(i = dm_size ; 1 <= i ; i --)//ダミーボーン除去　
		{
		    if(i == dm_size)
		    {
			    dm_id = dm_Item[dm_size].id;
		        SelectItem(dm_id);
		    }
			else
			{
			    dm_id = dm_Item[i].id;
				AddToSelection(dm_id);
			}
		}
		ClearSelected(1);
		end_b = sel_Item[1].name + "_end";
		if( sel_Item[1].firstChild().name == end_b)
		{
			SelectItem(end_b);
			ClearSelected(1);
		}
		for(i = sel_size ; 1 <= i ; i --)
		{
		    if(i == sel_size)
		    {
			    sel_id = sel_Item[sel_size].id;
		        SelectItem(sel_id);
				if(var2 == 1)
			    {
			        ItemColor(C_Col);
			    }
		    }
			else
			{
			    sel_id = sel_Item[i].id;
				AddToSelection(sel_id);
				if(var2 == 1)
			    {
			        ItemColor(C_Col);
			    }
			}
		}
	}
	store( "cl_col", C_Col );
	store( "bc", var2 );
}
localBRL_2: child, sel_Item, sel_size, dm_bone
{
   sel_n = sel_Item[sel_size].name;
   mys = "_meyasu";//「ボーンの長さ」用のボーン作成

        if(dm_bone == 1)
        {
           tgt_cld = sel_Item[sel_size].firstChild().name;
		   sel_mys = sel_n + mys;
	       SelectItem(sel_n + "_dm");
	       MotOp_Rot( 1, sel_n, 7, 7, 7);
           RefreshNow();
           CreateKey(0);
           MotOp_Rot( 0, 0, 1, 1, 1);
	       AddChildBone(sel_mys);//「ボーンの長さ」用のボーン作成(ダミーボーンの子）
           MotOp_Pos(1, tgt_cld, 7, 7, 7);
           RefreshNow();
           CreateKey(0);
	       scn = Scene();//Z値からボーンの長さを出す
           st_Item = scn.getSelect();
           BRLength = st_Item[1].getPosition(0).z;
	       SelectItem(st_Item[1].parent.id);
	       BoneRestLength(BRLength);
           SelectItem(st_Item[1].id);
	       AddToSelection(sel_mys);
           ClearSelected(1);
        }
        else
        {
	        SelectItem(sel_n - "_dm");
			
			scn = Scene();//Z値からボーンの長さを出す
            st_Item = scn.getSelect();
	        MotOp_Pos(1, sel_n, 7, 7, 7);
	        MotOp_Rot( 1, sel_n, 7, 7, 7);
	        RefreshNow();
            CreateKey(0);
		    dm_x = st_Item[1].getPosition(0).x;
		    dm_y = st_Item[1].getPosition(0).y;
		    dm_z = st_Item[1].getPosition(0).z;
			test_x = abs(dm_x);
			test_y = abs(dm_y);
			test_z = abs(dm_z);
	        MotOp_Pos( 0, 0, 1, 1, 1);
            MotOp_Rot( 0, 0, 1, 1, 1);
			if(test_x == 0)//x
            {
            }
            else
            {
                if(test_x < 0.0001)
	            dm_x = 0;
            }
			if(test_y == 0)//y
            {
            }
            else
            {
                if(test_y < 0.0001)
	            dm_y = 0;
            }
			if(test_z == 0)//z
            {
            }
            else
            {
                if(test_z < 0.0001)
	            dm_z = 0;
            }
			Position(dm_x, dm_y, dm_z);
			RefreshNow();
			CreateKey(0);
	        BRLength = sel_Item[sel_size].restlength;
	        BoneRestLength(BRLength);
			if(child != nil)
			{
			    dmc_x = st_Item[1].firstChild().getPosition(0).x;
		        dmc_y = st_Item[1].firstChild().getPosition(0).y;
		        dmc_z = st_Item[1].firstChild().getPosition(0).z;
				test_cx = abs(dmc_x);
			    test_cy = abs(dmc_y);
			    test_cz = abs(dmc_z);
				SelectItem(st_Item[1].firstChild().name);
			    if(test_cx == 0)//x
                {
                }
                else
                {
                    if(test_cx < 0.0001)
	                dmc_x = 0;
                }
			    if(test_cy == 0)//y
                {
                }
                else
                {
                    if(test_cy < 0.0001)
	                dmc_y = 0;
                }
			    if(test_cz == 0)//z
                {
                }
                else
                {
                    if(test_cz < 0.0001)
	                dmc_z = 0;
                }
			    Position(dmc_x, dmc_y, dmc_z);
			    RefreshNow();
			    CreateKey(0);
			}
        }
}
MotOp_Pos: itemW, item, co1, co2, co3
{
   PositionItemWorld(itemW);//リスケールボーンの位置をsel_idに追従
   PositionItem(item);
   XController(co1);YController(co2);ZController(co3);
}
MotOp_Rot: itemW, item, co1, co2, co3
{
   RotationItemWorld(itemW);//リスケールボーンの回転をsel_idに追従
   RotationItem(item);
   HController(co1);PController(co2);BController(co3);
}
option: tgtname, upvname , Hcon, Pcon, Bcon
{
    TargetItem(tgtname);
	PoleItem(upvname);
    HController(Hcon);
    PController(Pcon);
	BController(Bcon);
}



Expr: ExprCreate, ExpName, ExpEquation, Tgt_Channnel, clear
{
  if(ExprCreate == 1)// Create
  {
    qq="\"";
    CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
    CommandInput(CommandExec);
    CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel + qq + "" + qq + ExpName + qq);
    CommandInput(CommandExec);
  }
  if(ExprCreate == 2)//Clear
  {
    qq="\"";
	CommandExec = ("GE_DetachExpression "+ qq + Tgt_Channnel + qq + "" + qq + ExpName + qq);
    CommandInput(CommandExec);
	if(clear == 1)
	{
	    CommandInput("GE_ClearUnusedExpressions");
	}
  }
}
AC1: value
{
  return(value==1);
}
AC2: value
{
  return(value!=1);
}