
-----------------------------------------------------------------------------
-- patissier
-----------------------------------------------------------------------------

DROP TABLE "patissier" CASCADE;

DROP SEQUENCE "patissier_seq";

CREATE SEQUENCE "patissier_seq";


CREATE TABLE "patissier"
(
	"id" INTEGER  NOT NULL,
	"first_name" VARCHAR(100),
	"family_name" VARCHAR(100),
	"comment" TEXT,
	"is_employee" BOOLEAN default 't',
	"created_at" TIMESTAMP,
	"updated_at" TIMESTAMP,
	PRIMARY KEY ("id")
);

COMMENT ON TABLE "patissier" IS '';


SET search_path TO public;
-----------------------------------------------------------------------------
-- sweet_category
-----------------------------------------------------------------------------

DROP TABLE "sweet_category" CASCADE;

DROP SEQUENCE "sweet_category_seq";

CREATE SEQUENCE "sweet_category_seq";


CREATE TABLE "sweet_category"
(
	"id" INTEGER  NOT NULL,
	"name" VARCHAR(100),
	"body" TEXT,
	"created_at" TIMESTAMP,
	"updated_at" TIMESTAMP,
	PRIMARY KEY ("id")
);

COMMENT ON TABLE "sweet_category" IS '';


SET search_path TO public;
-----------------------------------------------------------------------------
-- sweet
-----------------------------------------------------------------------------

DROP TABLE "sweet" CASCADE;

DROP SEQUENCE "sweet_seq";

CREATE SEQUENCE "sweet_seq";


CREATE TABLE "sweet"
(
	"id" INTEGER  NOT NULL,
	"sweet_category_id" INTEGER,
	"patissier_id" INTEGER,
	"name" VARCHAR(100),
	"body" TEXT,
	"price" INTEGER,
	"is_display" BOOLEAN default 't',
	"created_at" TIMESTAMP,
	"updated_at" TIMESTAMP,
	PRIMARY KEY ("id")
);

COMMENT ON TABLE "sweet" IS '';


SET search_path TO public;
ALTER TABLE "sweet" ADD CONSTRAINT "sweet_FK_1" FOREIGN KEY ("sweet_category_id") REFERENCES "sweet_category" ("id");

ALTER TABLE "sweet" ADD CONSTRAINT "sweet_FK_2" FOREIGN KEY ("patissier_id") REFERENCES "patissier" ("id");
