<?php

/**
 * sfStructureNode page(has children/ terminate)
 * 1ノードには1ルーティング名が対応します。
 * ※動的(?id=*)は未対応
 *
 * @package    symfony
 * @subpackage plugin
 * @author     flyfront <flyfront@gmail.com>
 * @version    SVN: $Id: actions.class.php 19 2008-05-01 05:57:57Z flyfront $
 */
class sfStructureNode
{
    /**
     * @var sfSiteStructure
     */
    static private $structure;
    
    /**
     * 親ノード
     * @var sfStructureNode
     */
    private $parent_node;
    
    /**
     * 親ノードのルーティング名
     * $parent_node が存在しない場合のみ代わりに使う
     */
    private $parent_routing;
    
    /**
     * 親ノードのルーティングパラメータ配列
     * $parent_node が存在しない場合にルーティング名と組み合わせて使う
     */
    private $parent_params = array();

    /**
     * 子のノード群
     * @var array (sfStructureNode)
     */
    private $child_nodes = array();
    
    /**
     * ルーティング名
     */
    private $routing;
    
    /**
     * ルーティングのパラメータ配列
     */
    private $params;
    
    /**
     * ページタイトル
     */
    private $title;
    
    /**
     * 実体(routing)のないタイトルだけの概念的にあるページ
     */
    private $is_nopage = false;
    
    public function __construct()
    {
        if (! self::$structure){
            self::$structure = sfSiteStructure::getInstance();
        }
    }
    
    public function initialize($routing, $title, $is_nopage = false, $params = array(), $child_nodes = array())
    {
        $this->setChildNodes($child_nodes);
        $this->setRouting($routing, $params);
        $this->setTitle($title);
        $this->setNopageStatus($is_nopage);
    }
    
    public function clear()
    {
        $this->setChildNodes(array());
        $this->setRouting(null);
        $this->setTitle(null);
        $this->setExistPageStatus();
    }
    
    public function setChildNodes($child_nodes)
    {
        foreach ($child_nodes as $child_node) {
            /* @var $child_node sfStructureNode  */
        	$child_node->setParentNode($this);
        }
        $this->child_nodes = $child_nodes;
    }
    
    public function hasChildNode()
    {
        if (0 < count($this->child_nodes)) {
            return true;
        }else {
        	return false;
        }
    }
    
    public function addChildNode($child_node)
    {
        if ($child_node instanceof sfStructureNode) {
            /* @var $child_node sfStructureNode  */
            $child_node->setParentNode($this);
        	$this->child_nodes[] = $child_node;
        }
    }
    
    public function getChildNodes()
    {
        return $this->child_nodes;
    }
    
    /**
     * 親ノードが未完成(再帰の関係で子ノードが不明、など)の場合は
     * ルーティング名だけ先に保存しておくと
     * sfStructureNode::getNodeByRoutingを使って完成したノードを取得可能
     * 
     * @see $this->getParentNode
     */
    public function setParentRouting($routing, $params = array())
    {
        $routing = self::$structure->trimCommercialAtMark($routing);
        $this->parent_routing = $routing;
        $this->parent_params = $params;
    }
    
    public function hasParentNode()
    {
        if ($this->parent_node || $this->parent_routing) {
            return true;
        }
        return false;
    }
    
    public function getParentNode()
    {
        if (!$this->parent_node) {
        	if ($this->parent_routing) {
        		$this->parent_node = self::$structure->getNodeByRouting($this->parent_routing, $this->parent_params);
        	}else{
        	    $this->parent_node = null;
        	}
        }
        return $this->parent_node;
    }
    
    /**
     * @param $parent_node sfStructureNode
     */
    public function setParentNode($parent_node)
    {
        $this->parent_node = $parent_node;
        $this->parent_routing = $parent_node->getRouting();
        $this->parent_params = $parent_node->getParams();
    }
    
    public function setRouting($routing, $params = array())
    {
        $routing = self::$structure->trimCommercialAtMark($routing);
        $this->routing = $routing;
        $this->params = $params;
    }
    
    public function getRouting()
    {
        return $this->routing;
    }
    
    public function getParams()
    {
        return $this->params;
    }
    
    public function getInternalUrl()
    {
    	$params = array();
    	foreach ($this->getParams() as $key => $value) {
    		$params[] = $key.'='.$value;
    	}
    	$url = '@'.$this->getRouting().($params ? '?'.implode('&', $params) : '');
    	return $url;
    }
    
    public function setTitle($title)
    {
        $this->title = $title;
    }
    
    public function getTitle()
    {
        return $this->title;
    }
    
    public function setNopageStatus($is_nopage = true)
    {
        $this->is_nopage = ($is_nopage);
    }
    
    public function setExistPageStatus()
    {
        $this->setNopageStatus(false);
    }
    
    public function isNopage()
    {
        return $this->is_nopage;
    }
    
    public function isExistPage()
    {
        return (!$this->is_nopage);
    }
}