<?php

/**
 * pdf actions.
 *
 * @package    sweets_shop
 * @subpackage pdf
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 2692 2006-11-15 21:03:55Z fabien $
 */
class pdfActions extends sfActions
{
  /**
   * Executes index action
   *
   */
  public function executeIndex()
  {
  }
  
  public function executeMyPdf()
  {
    sfConfig::set('sf_web_debug', false);
    /* 
     * せっかくsymfony上で動かしているので、
     * html生成はsymfonyのテンプレート機能を使う。
     */
    $pdf_body = $this->getPresentationFor(
      $this->getModuleName(),
      'myPdfBody'
    );
    
    $pdf = new sfTCPDF();
    $left_margin = 20;
    $top_margin = 30;
    $right_margin = 20;
    $pdf->SetMargins(
      $top_margin,
      $left_margin,
      $right_margin
    );
    
    //arialunicid0 を指定すると
    //フォント埋め込まないっぽい
    $font_family = 'arialunicid0';
    $font_style = ''; //regular
    $font_size = 18;
    $pdf->SetFont(
      $font_family,
      $font_style,
      $font_size
    );
    
    /* 
     * Y軸が指定位置まできたら、
     *  自動的に改行してくれるオプション
     * 改行は自分で調整するので、
     *  0(ページ最下段)にしておく
     * 正直、ここの単位はよく分かりませんｗ
     */
    $pdf->SetAutoPageBreak(true, 0);
    
    $pdf->AddPage();
    $pdf->writeHTML($pdf_body);
    
    $pdf->Output('my_pdf.pdf' ,'D');
    
    throw new sfStopException();
  }
  
  public function executeMyPdfBody()
  {
    sfConfig::set('sf_web_debug', false);
    $this->hoge = 
      $this->getRequestParameter(
        'hoge',
        'no_param'
      );
    return sfView::SUCCESS;
  }
}
