﻿// System.EnvironmentExtension.GetResourceString.cs
// 1.0.*.1

using System.Diagnostics;
using System.Globalization;
using System.Reflection;
using System.Resources;
using System.Threading;

namespace System
{
    static partial class EnvironmentExtension
    {
        private static ResourceManager _ResourceManager;
        [DebuggerStepThrough]
        internal static String GetResourceString(String key)
        {
            if(_ResourceManager == null)
                Interlocked.CompareExchange(ref _ResourceManager, new ResourceManager("mscorlib", Assembly.Load("mscorlib, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089")), null);
            return String.IsNullOrEmpty(key) ? null : _ResourceManager.GetString(key, CultureInfo.CurrentCulture);
        }
        [DebuggerStepThrough]
        internal static String GetResourceString(String key, params Object[] values)
        {
            return String.Format(GetResourceString(key), values);
        }
    }
}
