using System;
using System.Collections.Generic;

namespace Chemics
{
    
    class SphericalHarmonicsManager:ServiceClient
    {
        private List<SphericalHarmonicsModel> normalModels = new List<SphericalHarmonicsModel>();
        private List<SphericalHarmonicsModel> squaredModels = new List<SphericalHarmonicsModel>();
        private int selectedIndex;
        public bool IsSquared = false;

        public void Initialize()
        {
            for (int azimuthalQNum = 0; azimuthalQNum < 5; azimuthalQNum++)
            {
                for (int magneticQNum = -azimuthalQNum; magneticQNum <= azimuthalQNum ; magneticQNum++)
                {
                    normalModels.Add(new SphericalHarmonicsModel(azimuthalQNum, magneticQNum, false));
                    squaredModels.Add(new SphericalHarmonicsModel(azimuthalQNum, magneticQNum, true));
                }
            }

            foreach (SphericalHarmonicsModel model in normalModels)
            {
                model.Services = Services;
                model.Initialize();
            }

            foreach (SphericalHarmonicsModel model in squaredModels)
            {
                model.Services = Services;
                model.Initialize();
            }
        }

        public void Next()
        {
            selectedIndex++;
            if (selectedIndex >= normalModels.Count)
            { selectedIndex = 0; }
        }

        public void Previous()
        {
            selectedIndex--;

            if (selectedIndex < 0)
            { selectedIndex = normalModels.Count - 1; }
        }

        public SphericalHarmonicsModel SelectedModel
        {
            get
            {
                if (IsSquared)
                { return squaredModels[selectedIndex]; }
                else
                { return normalModels[selectedIndex]; }
            }
        }


    }
}
