using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Chemics
{
    class ColorModel:ServiceClient, IGraphicsContent
    {
        protected VertexDeclaration VertexDeclaration;
        protected List<VertexPositionNormalColor> Vertices = new List<VertexPositionNormalColor>();
        private VertexBuffer vertexBuffer;

        public void LoadGraphicsContent(bool loadAllContent)
        {
            if (loadAllContent)
            {
                VertexDeclaration = new VertexDeclaration(
                    GetService<IGraphicsDeviceService>().GraphicsDevice,
                    VertexPositionNormalColor.VertexElements
                    );

                vertexBuffer = new VertexBuffer(
                    GetService<IGraphicsDeviceService>().GraphicsDevice,
                    Vertices.Count * VertexPositionNormalColor.SizeInBytes,
                    ResourceUsage.WriteOnly
                    );
                vertexBuffer.SetData<VertexPositionNormalColor>(Vertices.ToArray());
            }
        }

        public void Draw()
        {
            IGraphicsDeviceService deviceService = GetService<IGraphicsDeviceService>();


            deviceService.GraphicsDevice.VertexDeclaration = VertexDeclaration;
            deviceService.GraphicsDevice.Vertices[0].SetSource(
                vertexBuffer,
                0,
                VertexPositionNormalColor.SizeInBytes
                );
            deviceService.GraphicsDevice.DrawPrimitives(
                PrimitiveType.TriangleList,
                0,
                Vertices.Count / 3
                );
        }
    }


    class AxisModel:ColorModel
    {
        public float Length = 20;
        public float ArrowPointLength = 3;

        private Vector3 getPosition(double angle)
        {
            return new Vector3((float)Math.Sin(angle), 0, (float)Math.Cos(angle));
        }

        public void Initialize()
        {
            for (double angle = 0; angle < 2 * Math.PI; angle += 0.1)
            {
                addArrowPointVertices(angle);
                addShaftVertices(angle);
            }
        }

        private void addArrowPointVertices(double angle)
        {
            VertexPositionNormalColor v1;
            v1.Position = new Vector3();
            v1.Normal = getArrowNormal(angle + 0.1 / 2);
            v1.Color = Color.Gray;

            VertexPositionNormalColor v2;
            v2.Position = getPosition(angle) + new Vector3(0, -ArrowPointLength, 0);
            v2.Normal = getArrowNormal(angle);
            v2.Color = Color.Gray;

            VertexPositionNormalColor v3;
            v3.Position = getPosition(angle + 0.1) + new Vector3(0, -ArrowPointLength, 0);
            v3.Normal = getArrowNormal(angle + 0.1);
            v3.Color = Color.Gray;

            Vertices.Add(v1);
            Vertices.Add(v3);
            Vertices.Add(v2);


            v2.Normal = new Vector3(0, -1, 0);
            v3.Normal = new Vector3(0, -1, 0);

            VertexPositionNormalColor v4;
            v4.Position = new Vector3(0, -ArrowPointLength, 0);
            v4.Normal = new Vector3(0, -1, 0);
            v4.Color = Color.Gray;

            Vertices.Add(v2);
            Vertices.Add(v3);
            Vertices.Add(v4);
        }

        private Vector3 getArrowNormal(double angle)
        {
            return getPosition(angle) + new Vector3(0, ArrowPointLength, 0);
        }

        private void addShaftVertices(double angle)
        {
            VertexPositionNormalColor v1;
            v1.Position = getPosition(angle) * 0.5f
                + new Vector3(0, -ArrowPointLength, 0);
            v1.Normal = getPosition(angle);
            v1.Color = Color.Gray;

            VertexPositionNormalColor v2;
            v2.Position = getPosition(angle + 0.1) * 0.5f
                + new Vector3(0, -ArrowPointLength, 0);
            v2.Normal = getPosition(angle + 0.1);
            v2.Color = Color.Gray;

            VertexPositionNormalColor v3 = v1;
            v3.Position += new Vector3(0, -(Length - ArrowPointLength), 0);

            VertexPositionNormalColor v4 = v2;
            v4.Position += new Vector3(0, -(Length - ArrowPointLength), 0);

            Vertices.Add(v1);
            Vertices.Add(v2);
            Vertices.Add(v4);

            Vertices.Add(v1);
            Vertices.Add(v4);
            Vertices.Add(v3);
        }




    }
}
