using Microsoft.Xna.Framework.Input;


namespace Chemics
{
    static class HandednessUtility
    {
        [System.Runtime.InteropServices.DllImport("user32")]
        static extern int GetSystemMetrics(int nIndex);
        const int SM_SWAPBUTTON = 23;

        public static bool IsLeftHanded
        {
            get
            {
                return GetSystemMetrics(SM_SWAPBUTTON) == 1;
            }
        }

        public static bool IsClicking(MouseState mouseState)
        {
            if (IsLeftHanded)
            {
                return mouseState.RightButton == ButtonState.Pressed;
            }
            else
            {
                return mouseState.LeftButton == ButtonState.Pressed;
            }
        }

    }
}
