using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework;
using System.Collections.Generic;

namespace Chemics
{
    class TextRenderer:ServiceClient, IGraphicsContent
    {
        SpriteBatch spriteBatch;
        SpriteFont font;
        List<TextToDraw> textsToDraw = new List<TextToDraw>();

        public void Initialize()
        {
            GetService<IGraphicsContentManager>().Add(this);
        }

        public void LoadGraphicsContent(bool loadAllContent)
        {
            spriteBatch = new SpriteBatch(
                GetService<IGraphicsDeviceService>().GraphicsDevice
                );
            font = GetService<ContentManager>().Load<SpriteFont>("Arial");
        }

        public void ChangePosition(Vector2 newPosition)
        {
            TextToDraw text = new TextToDraw();
            text.Position = newPosition;
            text.Text = "";
            textsToDraw.Add(text);
        }

        public void Begin()
        {
            spriteBatch.Begin();
            textsToDraw.Add(new TextToDraw());
        }

        public void DrawLine(string text)
        {
            TextToDraw textToDraw = textsToDraw[textsToDraw.Count - 1];
            textToDraw.Text += (text + System.Environment.NewLine);
            textsToDraw[textsToDraw.Count - 1] = textToDraw;

        }

        public void End()
        {
            foreach (TextToDraw text in textsToDraw)
            {
                spriteBatch.DrawString(font, text.Text, text.Position, Color.White);
            }

            spriteBatch.End();
            GetService<IGraphicsDeviceService>().GraphicsDevice.RenderState.DepthBufferEnable = true;
            textsToDraw.Clear();
        }

        struct TextToDraw
        {
            public Vector2 Position;
            public string Text;
        }
    }
}
