using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Chemics
{
    public struct VertexPositionNormalColor
    {
        public Vector3 Position;
        public Vector3 Normal;
        public Color Color;

        public VertexPositionNormalColor(Vector3 position, Vector3 normal, Color color)
        {
            this.Position = position;
            this.Normal = normal;
            this.Color = color;
        }

        public static readonly VertexElement[] VertexElements
            = {new VertexElement(0, 0, VertexElementFormat.Vector3, VertexElementMethod.Default, VertexElementUsage.Position, 0),
                new VertexElement(0, sizeof(float) * 3, VertexElementFormat.Vector3, VertexElementMethod.Default, VertexElementUsage.Normal, 0),
                new VertexElement(0, sizeof(float)*(3 + 3), VertexElementFormat.Color, VertexElementMethod.Default, VertexElementUsage.Color, 0)
            };

        public static readonly int SizeInBytes = sizeof(float) * (3 + 3) + sizeof(byte) * 4;
    }
}
