using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MyFireballTest
{ 
    struct FireVertex
    {
        public Vector3 Position;
        public float Size;
        public Vector3 Velocity;
        public float StartTime;
        public Vector4 Random;

        public static readonly VertexElement[] VertexElements = { 
            new VertexElement(
            0, 0, VertexElementFormat.Vector3,
            VertexElementMethod.Default,
            VertexElementUsage.Position, 0) ,

            new VertexElement(
            0, 3 * sizeof(float), VertexElementFormat.Single,
            VertexElementMethod.Default,
            VertexElementUsage.PointSize, 0),

            new VertexElement(
            0, (3 + 1) * sizeof(float), VertexElementFormat.Vector3,
            VertexElementMethod.Default, VertexElementUsage.Position, 1),

            new VertexElement(
            0, (3 + 1 + 3) * sizeof(float), VertexElementFormat.Single,
            VertexElementMethod.Default, VertexElementUsage.PointSize, 1),

            new VertexElement(
                0, (3 + 1 + 3 + 1)*sizeof(float), VertexElementFormat.Vector4,
                VertexElementMethod.Default, VertexElementUsage.Color, 0)
        };
    }

}
