float4x4 World;
float4x4 View;
float4x4 Projection;
float ViewportHeight;

float CurrentTime;
float3 Acceleration;
float Duration = 2;

float4 MinColor = float4(1, 1, 1, 0.04);
float4 MaxColor = float4(1, 1, 1, 0.16);

float Scale;

texture FireTexture;

sampler fireTextureSampler = sampler_state
{
	Texture = (FireTexture);
};

struct FireballVertexShaderOutput
{
	float4 Position : POSITION;
	float Size : PSIZE;
	float4 Color : COLOR;
};

float4 ComputeFirevertexPosition(float4 startPosition, float4 velocity, float startTime)
{
	float time = CurrentTime - startTime;
	float3 position = startPosition + velocity * time + Acceleration * time * time / 2 / Scale;
	return mul(float4(position, 1), mul(mul(World , View), Projection));
}

float4 ComputeColor(float randomValue, float normalizedAge)
{
	float4 color = lerp(MinColor, MaxColor, randomValue);
	color.a *= normalizedAge * (1 - normalizedAge) * (1 - normalizedAge) * 6.7;
	return color;
}

FireballVertexShaderOutput FireballVertexShader(
	float4 position : POSITION0, float size : PSIZE0, float4 velocity : POSITION1, float startTime:PSIZE1, float4 randomness:COLOR
	)
{
	FireballVertexShaderOutput result;
	
	float age = CurrentTime - startTime;
	age *= 1 + randomness.x/2;
	float normalizedAge = saturate(age / Duration);
	
	result.Position = ComputeFirevertexPosition(position, velocity, startTime);
	result.Size = size * Projection._m11 / result.Position.w * ViewportHeight / 2 * Scale;
	result.Color = ComputeColor(randomness.x, normalizedAge);
	return result;
}

float4 FireballPixelShader(float2 texCoord : TEXCOORD, float4 color: COLOR) : COLOR
{
	return (tex2D(fireTextureSampler, texCoord) + float4(0.1, 0.1, 0.1, 0))
	 /1.1 * color;
}

technique FireballTechnique
{
	pass FireballPass
	{
		VertexShader = compile vs_2_0 FireballVertexShader();
		PixelShader = compile ps_2_0 FireballPixelShader();
	}
}