#region Using Statements
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
#endregion

namespace MyFireballTest
{

    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        FireballRenderer fireballRenderer;

        float rotationY;
        float rotationX;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            this.fireballRenderer = new FireballRenderer(this);
            this.Components.Add(fireballRenderer);
        }


        protected override void Initialize()
        {
            fireballRenderer.AddFireball(new Vector3(), 2, new Vector3(0, 10, 0));
            fireballRenderer.AddFireball(new Vector3(3, 0, 0), 1, new Vector3(0, 10, 0));
            fireballRenderer.AddFireball(new Vector3(-5, 0, -2), 1, new Vector3(0, 10, 0));

            base.Initialize();
        }

        protected override void Update(GameTime gameTime)
        {
            KeyboardState keyState = Keyboard.GetState();

            if (keyState.IsKeyDown(Keys.Left))
            {
                rotationY -= 0.03f;
            }
            if (keyState.IsKeyDown(Keys.Right))
            {
                rotationY += 0.03f;
            }
            if (keyState.IsKeyDown(Keys.Up))
            {
                rotationX -= 0.03f;
            }
            if (keyState.IsKeyDown(Keys.Down))
            {
                rotationX += 0.03f;
            }

            Matrix view = Matrix.CreateRotationY(rotationY) 
                * Matrix.CreateRotationX(rotationX)
                * Matrix.CreateLookAt(new Vector3(0, 0, 10), new Vector3(), new Vector3(0, 1, 0));

            fireballRenderer.SetCamera(
                view,
                Matrix.CreatePerspectiveFieldOfView(MathHelper.ToRadians(90), 1, 0.1f, 1000)
                );

            base.Update(gameTime);
        }


        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.Gray);


            base.Draw(gameTime);
        }
    }
}
