

using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;


namespace PSSMDemo
{
    class Scene
    {
        private List<SceneObject> sceneObjects = new List<SceneObject>();
        private BoundingBox boundingBox = new BoundingBox();

        private GraphicsDevice device;
        private ContentManager content;

        public Scene(GraphicsDevice device, ContentManager content)
        {
            this.device = device;
            this.content = content;
        }

        public BoundingBox Bounds
        {
            get
            {
                return boundingBox;
            }
        }

        public void AddObject(String objectName, String textureName, Vector3 position)
        {
            SceneObject sceneObject = new SceneObject();

            sceneObject.MeshName = objectName;
            sceneObject.TextureName = textureName;
            sceneObject.Position = position;
            sceneObject.Scene = this;
            sceneObject.Load(content);

            sceneObjects.Add(sceneObject);
        }

        
        public void AddBoundingBox(BoundingBox bb)
        {
            boundingBox = BoundingBox.CreateMerged(boundingBox, bb);
        }


        public void Draw(GraphicsDevice device, Effect effect)
        {
            foreach (SceneObject sceneObject in sceneObjects)
            {
                sceneObject.Draw(device, effect);
            }
        }

        public void DrawTextured(GraphicsDevice device, Effect effect)
        {
            foreach (SceneObject sceneObject in sceneObjects)
            {
                sceneObject.DrawTextured(device, effect);
            }
        }
    }
}
