using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace ShadowMaps
{
    /// <summary>
    /// `p̃fQ[głB
    /// </summary>
    public delegate void Drawer();

    /// <summary>
    /// pEXvbgEVhE}bvZ@ɕKvȂ̂JvZNXłB
    /// </summary>
    public class PssmDrawer
    {
        #region vpeBAϐ
        /// <summary>
        /// ̃NXDraw\bhŎgJłB
        /// ̃IuWFNg̏ƂɁAǂ̗̈̃VhE}bv邩肵܂B
        /// ̃IuWFNg̃vpeBύX̂́ÃNXDraw\bhĂԑOɍsĂB
        /// </summary>
        public PssmCamera Camera = new PssmCamera();

        /// <summary>
        /// ̃NXDraw\bhŃp[^[𒲐郉CgłB
        /// ̃IuWFNgA[U[̓VhE}bv`悷鎞ɎgShadowMapMatrix}gNX𓾂邱Ƃł܂B
        /// </summary>
        public PssmLight Light = new PssmLight();


        /// <summary>
        /// ěvZɍlV[̗̈łB
        /// ꂪ\ɑ傫ȂƁAeĂȂꏊoĂ܂ł傤B
        /// tɁAꂪ傫ƁAẻ𑜓xȂĂ܂܂B
        /// </summary>
        public BoundingBox SceneBounds;

        private Vector3[] frustumCorners = new Vector3[8];


        /// <summary>
        /// J̎𕪊ĂłȎ̐łB
        /// ̐傫Α傫قǉe͑NɂȂ܂Aʕׂ͍܂܂B
        /// ̃vpeB̒lƓVhE}bvƃV[̕`JԂłB
        /// </summary>
        public int SplitCount
        {
            get { return splitCount; }
            set
            {
                splitCount = value;
                splitDistances = new float[splitCount + 1];
            }
        }
        private int splitCount;
        private float[] splitDistances = null;



        //fQ[g̓ptH[}XɏX肪̂ŁA
        //ƂTemplateMethodp^[gׂ܂B

        /// <summary>
        /// VhE}bv`悷ׂɌĂ΂郁\bh̃fQ[głB
        /// ʂ̃VhE}bvZ@VhE}bv̕`xsȂ̂ƑΏƓIɁA
        /// PSSMł̓VhE}bv̕`񂩂ɕčs܂B
        /// ɃZbgꂽ\bh́AVhE}bv`悷ׂ^C~OɓK؂ȉ񐔁iSplitCountvpeBŐݒł܂jĂ΂܂B
        /// ̃\bh̒ɂ́A[U[`̃_[^[Qbgɑ΂AVhE}bv`悷R[hĂ܂B
        /// VhE}bv`悷郁\bh͕ʂ̃VhE}bvZ@̂̂Ɠō\܂B
        /// ̃NXDraw\bh̒ŁAr[|[g̒lȂǁAVhE}bv̕`ɕKvȐݒ͎Iɍs܂B
        /// </summary>
        public Drawer DrawShadowMap;

        /// <summary>
        /// V[`悷ׂ^C~OɌĂ΂郁\bh̃fQ[głB
        /// </summary>
        public Drawer DrawWithShadow;

        private GraphicsDevice GraphicsDevice;
        #endregion

        /// <summary>
        /// w肳ꂽOtBbNXfoCXɂď܂B
        /// </summary>
        /// <param name="graphicsDevice">̃NXgƂɂȂOtBbNXfoCXłBDraw\bh̒Ŏg܂B</param>
        public PssmDrawer(GraphicsDevice graphicsDevice)
        {
            SplitCount = 2;
            this.GraphicsDevice = graphicsDevice;
        }

        /// <summary>
        /// etĕ`s܂B
        /// ̃\bh̒ł́ADrawShadowMapDrawWithShadowfQ[gɃZbgꂽ\bhĂяo܂B
        /// Ă΂񐔂SplitCountvpeB̒lŌ肳܂B
        /// ZɕāAJɋ߂Ƃ납牓ɏԂɕ`悵Ă̂łB
        /// </summary>
        public void Draw()
        {
            Camera.AdjustFarPlane(SceneBounds);
            Camera.GetSplitDistances(splitDistances, 0.5f);


            Viewport oldViewport = GraphicsDevice.Viewport;

            //O珇
            //1.VhE}bv쐬
            //2.etĕ`
            //SplitCountJԂ܂B
            for (int split = 0; split < splitCount; split++)
            {
                //_łnearfarA
                //܂J̋ɊÂA`悷̈߂܂B
                float near = splitDistances[split];
                float far = splitDistances[split + 1];

                //ꂽ̏𑜓xMaxŃVhE}bv`ł悤ɁA
                //CgƂ炷͈͂ŏɍi܂B
                Camera.GetFrustumCorners(frustumCorners, near, far);
                Light.NextSplit(frustumCorners);

                //fQ[gďoiVhE}bv̕`j
                DrawShadowMap();



                //ȑO`悵㏑Ă܂Ȃ悤ɁA
                //r[|[g̐[x̒l𒲐߂܂B
                Viewport cameraViewport = GraphicsDevice.Viewport;
                cameraViewport.MinDepth = (float)split / splitCount;
                cameraViewport.MaxDepth = (float)(split + 1) / splitCount;
                GraphicsDevice.Viewport = cameraViewport;
                //͂Ȃ񂾂낤cc
                //nearfar͂Ȃ悤ȋC܂ȂƉeȂ܂
                Camera.NextSplit(near, far);

                //fQ[gďoietĕ`j
                DrawWithShadow();
            }

            GraphicsDevice.Viewport = oldViewport;

        }

        
    }
}
