
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

using ShadowMaps;

namespace PSSMDemo
{
    /// <summary>
    /// pEXvbgEVhE}bvZ@̃fs܂B
    /// ł́AX̒FؔΐF̒nʂɉe𗎂Ƃ܂B
    /// ZL[XL[ƂɂāAVhE}bv̕A
    /// ܂肻̉ê͂ς邱Ƃł܂B
    /// iftHgł̓VhE}bvQĂ̂ŁAe͂茩܂j
    /// </summary>
    public class PssmDemoGame : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;

        /// <summary>
        /// ̃vOŕ`悷IuWFNgǗ܂B
        /// ̓Iɂ́A΂̒nʂƂX̖ؔō\Ă܂B
        /// </summary>
        private Scene scene;


        //VhE}bv̂ɕKvȕϐQłB
        private Effect shadowMapEffect;
        private RenderTarget2D shadowMap;
        private const int shadowMapSize = 1024;
        private DepthStencilBuffer shadowDepthStencilBuffer;

        /// <summary>
        /// pEXvbgEVhE}bvZ@́A
        /// VhE}bvƋʂɂłȂJvZĂ܂B
        /// </summary>
        private PssmDrawer pssm;


        public PssmDemoGame()
        {
            graphics = new GraphicsDeviceManager(this);

            this.graphics.PreferredBackBufferWidth = 1025;
            this.graphics.PreferredBackBufferHeight = 720;
        }



        protected override void LoadContent()
        {
            pssm = new PssmDrawer(GraphicsDevice);
            pssm.DrawShadowMap = drawShadowMap;
            pssm.DrawWithShadow = drawWithShadow;
            pssm.Camera.AspectRatio = GraphicsDevice.Viewport.AspectRatio;



            //ʂɕ`悷IuWFNg܂B
            scene = new Scene(GraphicsDevice, Content);

            //nʂƂX̃TCRiHj[h܂B
            scene.AddObject("ground", "t_ground", new Vector3(0, 0, 0));

            for (int x = 0; x < 3; x++)
            {
                for (int z = 0; z < 3; z++)
                {
                    scene.AddObject(
                        "crate",
                        "t_crate",
                        new Vector3(x + x * 2.5f - 4.0f, 1.0f, z + z * 2.5f - 4.0f)
                        );
                }
            }


            //VhE}bvɎg_[^[QbgƐ[xXeVobt@𐶐
            shadowMap = new RenderTarget2D(
                graphics.GraphicsDevice,
                shadowMapSize, shadowMapSize,
                1,
                SurfaceFormat.Single
                );
            shadowDepthStencilBuffer = new DepthStencilBuffer(
                graphics.GraphicsDevice,
                shadowMapSize, shadowMapSize,
                DepthFormat.Depth24Stencil8
                );


            //VhE}bvZ@s\͂EffectIuWFNg܂B
            //CgƂ̑e̂ɕKvȃp[^[Zbg܂B
            shadowMapEffect = Content.Load<Effect>("Fx/ShadowMap");
            shadowMapEffect.Parameters["lightDirection"].SetValue(pssm.Light.Direction);
            shadowMapEffect.Parameters["lightColor"].SetValue(new Vector3(0.9f, 0.9f, 1.0f));
            shadowMapEffect.Parameters["ambientColor"].SetValue(new Vector3(0.625f, 0.625f, 0.625f));
            shadowMapEffect.Parameters["shadowMapSize"].SetValue((float)shadowMapSize);
        }

        protected override void UnloadContent()
        {
            shadowMap.Dispose();
            shadowDepthStencilBuffer.Dispose();
        }


        /// <summary>
        /// Update\bhŎgϐłB
        /// L[{[hZĂ邩ǂ\܂B
        /// </summary>
        bool notDownZ = true;

        /// <summary>
        /// Update\bhŎgϐłB
        /// L[{[hXĂ邩ǂ\܂B
        /// </summary>
        bool notDownX = true;

        /// <summary>
        /// L[{[h́őO㍶Eɕ̂𓮂܂B
        /// Aŕ̂ɁADŕ̂ɓ܂Bi{͓Ă̂̓Jłj
        /// ZƉẻ𑜓xオiVhE}bv̕ȂjA
        /// XƉẻ𑜓x܂iVhE}bv̕ȂȂjB
        /// ܂AEBhẼ^CgɌ݂̃VhE}bv̕\܂B
        /// </summary>
        /// <param name="gameTime"></param>
        protected override void Update(GameTime gameTime)
        {
            KeyboardState keyState = Keyboard.GetState();

            PssmCamera camera = pssm.Camera;


            if (keyState.IsKeyDown(Keys.Left))
            {
                camera.Position.X -= 0.5f;
            }
            if (keyState.IsKeyDown(Keys.Right))
            {
                camera.Position.X += 0.5f;
            }


            if (keyState.IsKeyDown(Keys.Up))
            {
                camera.Position.Z -= 0.5f;
            }
            if (keyState.IsKeyDown(Keys.Down))
            {
                camera.Position.Z += 0.5f;
            }


            if (keyState.IsKeyDown(Keys.A))
            {
                camera.Position.Y += 0.5f;
            }
            if (keyState.IsKeyDown(Keys.D))
            {
                camera.Position.Y -= 0.5f;
            }


            if (keyState.IsKeyDown(Keys.Z))
            {
                if (notDownZ)
                {
                    if (pssm.SplitCount < 9)
                    {
                        pssm.SplitCount++;
                    }

                    notDownZ = false;
                }
            }
            else
            {
                notDownZ = true;
            }

            if (keyState.IsKeyDown(Keys.X))
            {
                if (notDownX)
                {
                    if (pssm.SplitCount > 1)
                    {
                        pssm.SplitCount--;
                    }

                    notDownX = false;
                }
            }
            else
            {
                notDownX = true;
            }

            Window.Title = "SplitCount of Shadow Map : " + pssm.SplitCount;

            base.Update(gameTime);
        }

        


        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            pssm.SceneBounds = scene.Bounds;
            pssm.Draw();

            base.Draw(gameTime);
        }


        /// <summary>
        /// VhE}bv`悷郁\bhłB
        /// ͈ꌩӂ̃VhE}bv`悷郁\bhƓ悤Ɍ܂A
        /// ĂяopxႢ܂ÃNX璼ڌĂяo邱Ƃ܂B
        /// PssmDrawer.DrawShadowMapfQ[gɃZbgA
        /// PssmDrawer.DrawĂ񂾎ɊԐړIɁAP`Ăяo܂B
        /// ĂяốAꂼႤ̈`悵Ă邩łB
        /// ܂Jɋ߂ꏊ𑜓xŕ`悵AJ牓ꏊႢ𑜓xŕ`悵Ă܂B
        /// </summary>
        private void drawShadowMap()
        {
            Viewport oldViewport = GraphicsDevice.Viewport;

            //VhE}bv̕`̏܂B
            DepthStencilBuffer defaultDepthStencilBuffer = GraphicsDevice.DepthStencilBuffer;
            GraphicsDevice.DepthStencilBuffer = shadowDepthStencilBuffer;
            GraphicsDevice.SetRenderTarget(0, shadowMap);
            GraphicsDevice.Clear(Color.White);

            shadowMapEffect.CurrentTechnique = shadowMapEffect.Techniques["RenderShadowMap"];

            PssmLight light = pssm.Light;
            shadowMapEffect.Parameters["viewProjection"].SetValue(light.ShadowMapMatrix);

            shadowMapEffect.Begin();

            //VhE}bv̕`s܂B
            foreach (EffectPass pass in shadowMapEffect.CurrentTechnique.Passes)
            {
                pass.Begin();
                scene.Draw(GraphicsDevice, shadowMapEffect);
                pass.End();
            }

            shadowMapEffect.End();

            //ЕtłB
            GraphicsDevice.DepthStencilBuffer = defaultDepthStencilBuffer;
            GraphicsDevice.SetRenderTarget(0, null);
            GraphicsDevice.Viewport = oldViewport;
        }


        /// <summary>
        /// ۂɉetăV[`悷郁\bhłB
        /// Ăяo܂B
        /// </summary>
        private void drawWithShadow()
        {
            float shadowMapTexOffset = 0.5f + (0.5f / (float)shadowMapSize);

            Matrix shadowMapTextureScale = 
                Matrix.CreateScale(0.5f, -0.5f, 1) 
                * Matrix.CreateTranslation(shadowMapTexOffset, shadowMapTexOffset, 0);


            shadowMapEffect.CurrentTechnique = shadowMapEffect.Techniques["Shadowed"];

            shadowMapEffect.Parameters["shadowMapMatrix"].SetValue(
                pssm.Light.ShadowMapMatrix * shadowMapTextureScale
                );
            shadowMapEffect.Parameters["viewProjection"].SetValue(
                pssm.Camera.View * pssm.Camera.Projection
                );
            shadowMapEffect.Parameters["shadowTexture"].SetValue(shadowMap.GetTexture());

            shadowMapEffect.Begin();

            foreach (EffectPass pass in shadowMapEffect.CurrentTechnique.Passes)
            {
                pass.Begin();
                scene.DrawTextured(GraphicsDevice, shadowMapEffect);
                pass.End();
            }

            shadowMapEffect.End();
        }
    }
}