
using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;


namespace PSSMDemo
{
    class SceneObject
    {
        private Model model;
        private Texture texture;

        public Scene Scene;
        public Vector3 Position = Vector3.One;
        public String TextureName;
        public String MeshName;


        public void Load(ContentManager content)
        {
            model = content.Load<Model>("Graphics/" + MeshName);

            if (TextureName != null)
            {
                texture = content.Load<Texture>("Graphics/" + TextureName);
            }

            foreach (ModelMesh mesh in model.Meshes)
            {
                BoundingBox bb = BoundingBox.CreateFromSphere(mesh.BoundingSphere);

                Scene.AddBoundingBox(bb);
            }
        }


        public void DrawTextured(GraphicsDevice device, Effect effect)
        {
            effect.Parameters["objectTexture"].SetValue(texture);

            Draw(device, effect);
        }


        public void Draw(GraphicsDevice device, Effect effect)
        {
            foreach (ModelMesh mesh in model.Meshes)
            {
                Matrix world = mesh.ParentBone.Transform * Matrix.CreateTranslation(Position);
                effect.Parameters["world"].SetValue(world);

                effect.CommitChanges();

                device.Indices = mesh.IndexBuffer;

                for (int i = 0; i < mesh.MeshParts.Count; i++)
                {
                    ModelMeshPart part = mesh.MeshParts[i];

                    if (part.NumVertices > 0)
                    {
                        device.VertexDeclaration = part.VertexDeclaration;
                        device.Vertices[0].SetSource(
                            mesh.VertexBuffer,
                            part.StreamOffset,
                            part.VertexStride
                            );
                        device.DrawIndexedPrimitives(
                            PrimitiveType.TriangleList,
                            part.BaseVertex,
                            0, 
                            part.NumVertices, 
                            part.StartIndex,
                            part.PrimitiveCount
                            );
                    }
                }
            }
        }
    }
}
