using System;
using Microsoft.Xna.Framework;


namespace ShadowMaps
{
    /// <summary>
    /// pEXvbgEVhE}bvZ@ŎgJ猩̈A
    /// ܂莋̂ǗNXłB
    /// pEXvbgEVhE}bvł͎̂ɕKv̂łA
    /// ̃NXł͂s܂B
    /// </summary>
    public class PssmCamera
    {
        #region vpeBƃoϐ
        private Matrix view;
        private Matrix projection;

        public Matrix View
        {
            get { return view; }
        }

        public Matrix Projection
        {
            get { return projection; }
        }
        
        public Vector3 Position = new Vector3(0, 30, 30);
        public Vector3 LookDirection = new Vector3(0, -1, -1);
        public Vector3 UpVector = new Vector3(0, 1, 0);

        public float Near = 0.5f;
        public float Far = 90.0f;
        public float FarMaxLimit = 400.0f;
        public float FieldOfView = MathHelper.ToRadians(90.0f);

        public float AspectRatio = 1;
        #endregion


        public void NextSplit(float splitedNear, float splitedFar)
        {
            view = Matrix.CreateLookAt(Position, Position + LookDirection, UpVector);

            projection = Matrix.CreatePerspectiveFieldOfView(
                FieldOfView,
                AspectRatio,
                splitedNear, splitedFar
                );
        }


        public void GetFrustumCorners(
            Vector3[] frustumCorners, float near, float far
            )
        {
            Vector3 vZ = Vector3.Normalize(LookDirection);

            Vector3 vX = Vector3.Normalize(
                Vector3.Cross(UpVector, vZ)
                );

            Vector3 vY = Vector3.Cross(vZ, vX);


            float nearPlaneHeight = (float)Math.Tan(FieldOfView / 2) * near;
            float nearPlaneWidth = nearPlaneHeight * AspectRatio;

            float farPlaneHeight = (float)Math.Tan(FieldOfView / 2) * far;
            float farPlaneWidth = farPlaneHeight * AspectRatio;

            Vector3 nearPlaneCenter = Position + vZ * near;
            Vector3 farPlaneCenter = Position + vZ * far;

            Vector3 vXnearPlaneWidth = vX * nearPlaneWidth;
            Vector3 vXfarPlaneWidth = vX * farPlaneWidth;

            Vector3 vYnearPlaneHeight = vY * nearPlaneHeight;
            Vector3 vYfarPlaneHeight = vY * farPlaneHeight;

            frustumCorners[0] = nearPlaneCenter - vXnearPlaneWidth - vYnearPlaneHeight;
            frustumCorners[1] = nearPlaneCenter - vXnearPlaneWidth + vYnearPlaneHeight;
            frustumCorners[2] = nearPlaneCenter + vXnearPlaneWidth + vYnearPlaneHeight;
            frustumCorners[3] = nearPlaneCenter + vXnearPlaneWidth - vYnearPlaneHeight;

            frustumCorners[4] = farPlaneCenter - vXfarPlaneWidth - vYfarPlaneHeight;
            frustumCorners[5] = farPlaneCenter - vXfarPlaneWidth + vYfarPlaneHeight;
            frustumCorners[6] = farPlaneCenter + vXfarPlaneWidth + vYfarPlaneHeight;
            frustumCorners[7] = farPlaneCenter + vXfarPlaneWidth - vYfarPlaneHeight;
        }


        /// <summary>
        /// JNearFar̒l𒲐߂āÅԂ̗̈悪Aw肳ꂽ̈悾ijݍ߂悤Ƀ_Ȃ܂B
        /// Farw肳ꂽ̈ƉɂȂAOɎĂ܂B
        /// </summary>
        /// <param name="sceneBounds">V[̗̈łB</param>
        public void AdjustFarPlane(BoundingBox sceneBounds)
        {
            view = Matrix.CreateLookAt(Position, Position + LookDirection, UpVector);

            //Jԗꂽ_̋vZ܂B
            float minZ = 0;
            Vector3[] sceneBoundsCorners = sceneBounds.GetCorners();

            for (int i = 0; i < 8; i++)
            {
                float z = Vector3.Transform(
                    sceneBoundsCorners[i],
                    view
                    ).Z;

                if (z < minZ)
                {
                    minZ = z;
                }
            }

            //FarAV[K܂ނƂtŁAłJɋ߂Â܂B
            this.Far = Near - minZ;
        }



        /// <summary>
        ///pEXvbgEVhE}bvZ@ōs̕A
        /// ̓Iɂǂȋɂ邩擾܂B
        /// ܂̂ŌƁAJɋ߂Ƃ͏āA
        /// J牓Ƃ͑傫̂łc
        /// </summary>
        /// <param name="splitDistances">ʂi[złB</param>
        /// <param name="splitSchemeLambda">Sɂƕƕ`̂ƂsNZȂ̂ŁAŁuVсvݒ肵܂BƂ΁A0.5fZbg邱Ƃł܂B</param>
        public void GetSplitDistances(float[] splitDistances, float splitSchemeLambda)
        {
            // Practical split scheme:
            //
            // CLi = n*(f/n)^(i/numsplits)
            // CUi = n + (f-n)*(i/numsplits)
            // Ci = CLi*(lambda) + CUi*(1-lambda)
            //
            // lambda scales between logarithmic and uniform
            //

            splitSchemeLambda = MathHelper.Clamp(splitSchemeLambda, 0.0f, 1.0f);

            int splitCount = (splitDistances.Length - 1);

            for (int i = 0; i < splitCount; i++)
            {
                float idm = (float)i / splitCount;
                float log = (float)(Near * Math.Pow(Far / Near, idm));
                float uniform = MathHelper.Lerp(Near, Far, idm);

                splitDistances[i] = 
                    log * splitSchemeLambda 
                    + uniform * (1 - splitSchemeLambda);
            }

            // make sure border values are right
            splitDistances[0] = Near;
            splitDistances[splitCount] = Far;
        }
    }
}
