
using System;
using Microsoft.Xna.Framework;


namespace ShadowMaps
{
    public class PssmLight
    {
        #region vpeBƕϐ
        private Matrix View
        {
            get
            {
                return Matrix.CreateLookAt(
                    Position,
                    Position + Direction,
                    UpVector
                    );
            }
        }

        private Matrix projection;
        private Matrix crop;

        public Matrix ShadowMapMatrix
        {
            get { return View * projection * crop; }
        }
        

        public Vector3 Direction = new Vector3(0.5f, -0.7071068f, 0.5f);
        public Vector3 UpVector = Vector3.Up;

        public float Near = 1.0f;
        public float Far = 400.0f;

        //Point Light Members.
        public Vector3 Position =  new Vector3(-50,@75,@-50);
        public float FieldOfView = MathHelper.ToRadians(90.0f);

        public bool IsPointLight = true;
        #endregion


        public void NextSplit(Vector3[] frustumCorners)
        {
            projection = createProjection();

            BoundingBox frustumBox = GetMinimumBoxIncludingFrustum(
                frustumCorners,
                projection
                );

            crop = CreateCropMatrix(frustumBox);
        }


        private Matrix createProjection()
        {
            if (IsPointLight)
            {
                return Matrix.CreatePerspectiveFieldOfView(
                    FieldOfView,
                    1,
                    Near, Far
                    );
            }

            float farPlaneSize = 2 * (float)Math.Tan(FieldOfView/2) * Far;
            return Matrix.CreateOrthographic(
                farPlaneSize, farPlaneSize,
                Near, Far
                );
        }

        private Matrix CreateCropMatrix(BoundingBox frustumBox)
        {
            Vector3 max = frustumBox.Max;
            Vector3 min = frustumBox.Min;

            float scaleX = 2.0f / (max.X - min.X);
            float scaleY = 2.0f / (max.Y - min.Y);

            float offsetX = -(max.X + min.X) / 2 * scaleX;
            float offsetY = -(max.Y + min.Y) / 2  * scaleY;

            float scaleZ = 1 / (max.Z - min.Z);
            float offsetZ = -min.Z * scaleZ;

            Matrix lightCropView =
                Matrix.CreateScale(scaleX, scaleY, scaleZ)
                * Matrix.CreateTranslation(offsetX, offsetY, offsetZ);
            return lightCropView;
        }

        private BoundingBox GetMinimumBoxIncludingFrustum(Vector3[] frustumCorners, Matrix projection)
        {
            BoundingBox result = new BoundingBox();
            result.Max = new Vector3(Single.MinValue, Single.MinValue, 0);
            result.Min = new Vector3(Single.MaxValue, Single.MaxValue, 0);

            Matrix lightViewProj = View * projection;

            for (int i = 0; i < 8; i++)
            {
                Vector4 transformed = Vector4.Transform(
                    frustumCorners[i],
                    lightViewProj
                    );

                transformed.X /= transformed.W;
                transformed.Y /= transformed.W;

                if (transformed.X > result.Max.X)
                {
                    result.Max.X = transformed.X;
                }

                if (transformed.Y > result.Max.Y)
                {
                    result.Max.Y = transformed.Y;
                }

                if (transformed.Y < result.Min.Y)
                {
                    result.Min.Y = transformed.Y;
                }

                if (transformed.X < result.Min.X)
                {
                    result.Min.X = transformed.X;
                }

                if (transformed.Z > result.Max.Z)
                {
                    result.Max.Z = transformed.Z;
                }
            }

            //xy-1`1͈̔͂ɐ؂l߂܂B
            result.Max.X = MathHelper.Clamp(result.Max.X, -1.0f, 1.0f);
            result.Max.Y = MathHelper.Clamp(result.Max.Y, -1.0f, 1.0f);

            result.Min.X = MathHelper.Clamp(result.Min.X, -1.0f, 1.0f);
            result.Min.Y = MathHelper.Clamp(result.Min.Y, -1.0f, 1.0f);

            return result;
        }
    }
}
