﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using System.Windows.Documents;
using System.Windows.Media;

namespace TextHtmlTransformer.Tests
{
    [TestFixture]
    public class FlowDocumentToHtmlConverterTest
    {
        [Test]
        public void Empty()
        {
            FlowDocument flowDocument = new FlowDocument();
            string html = FlowDocumentToHtmlConverter.Convert(flowDocument);
            Assert.AreEqual("<pre></pre>", html);
        }

        [Test]
        public void Text()
        {
            FlowDocument flowDocument = new FlowDocument();
            flowDocument.Blocks.Add(new Paragraph(new Run("test")));
            string html = FlowDocumentToHtmlConverter.Convert(flowDocument);
            Assert.AreEqual("<pre>test\n</pre>", html);
        }

        [Test]
        public void ColoredText()
        {
            FlowDocument flowDocument = new FlowDocument();
            flowDocument.Blocks.Add(new Paragraph(new Run("Test") { Foreground=new SolidColorBrush(Colors.Blue)}));
            string html = FlowDocumentToHtmlConverter.Convert(flowDocument);
            Assert.AreEqual("<pre><span style=\"color:#0000FF;\">Test</span>\n</pre>", html);
        }

        [Test]
        public void Encoded()
        {
            FlowDocument flowDocument = new FlowDocument();
            flowDocument.Blocks.Add(new Paragraph(new Run("<")));
            string html = FlowDocumentToHtmlConverter.Convert(flowDocument);
            Assert.AreEqual("<pre>&lt;\n</pre>", html);
        }

        
        [Test]
        public void Span()
        {
            FlowDocument flowDocument = new FlowDocument();
            flowDocument.Blocks.Add(new Paragraph(new Span { Inlines = { new Run("test") } }));
            string html = FlowDocumentToHtmlConverter.Convert(flowDocument);
            Assert.AreEqual("<pre>test\n</pre>", html);
        }

        [Test]
        public void SpanColor()
        {
            FlowDocument flowDocument = new FlowDocument();
            var paragraph = new Paragraph(
                new Span
                {
                    Inlines = { new Run("test") },
                    Foreground = new SolidColorBrush(Colors.Blue)
                }
                );
            flowDocument.Blocks.Add(paragraph);
            string html = FlowDocumentToHtmlConverter.Convert(flowDocument);
            Assert.AreEqual("<pre><span style=\"color:#0000FF;\">test</span>\n</pre>", html);
        }

        [Test]
        public void DoubleSpanColor()
        {
            FlowDocument flowDocument = new FlowDocument();
            var paragraph = new Paragraph(
                new Span
                {
                    Inlines = { new Run("test") { Foreground = new SolidColorBrush(Colors.Blue)} },
                    Foreground = new SolidColorBrush(Colors.Blue)
                }
                );
            flowDocument.Blocks.Add(paragraph);
            string html = FlowDocumentToHtmlConverter.Convert(flowDocument);
            Assert.AreEqual("<pre><span style=\"color:#0000FF;\">test</span>\n</pre>", html);
        }

        [Test]
        public void IgnoreBlockUIContainer()
        {
            FlowDocument flowDocument = new FlowDocument();
            flowDocument.Blocks.Add(new BlockUIContainer());
            string html = FlowDocumentToHtmlConverter.Convert(flowDocument);
            Assert.AreEqual("<pre></pre>", html);
        }
      
    }
}
