﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TextHtmlTransformer
{
    public abstract class InlineModel
    {
        public string Color;

        public abstract string GetTextContent();

        public override string ToString()
        {
            return GetSpanStart() + GetTextContent() + GetSpanEnd();
        }

        public string GetSpanStart()
        {
            if (isDefaultColor())
            {
                return "";
            }

            return "<span style=\"color:" + Color + ";\">";
        }

        public string GetSpanEnd()
        {
            if (isDefaultColor())
            {
                return "";
            }

            return "</span>";
        }

        private bool isDefaultColor()
        {
            return Color == "#000000" || string.IsNullOrEmpty(Color);
        }
    }

    public class RunModel : InlineModel
    {
        public string Text = "";

        public override string GetTextContent()
        {
            return Text;
        }

    }

    public class SpanModel : InlineModel
    {
        public List<InlineModel> Children = new List<InlineModel>();

        public override string GetTextContent()
        {
            var result = new StringBuilder();

            foreach (var child in Children)
            {
                result.Append(child.ToString());
            }

            return result.ToString();
        }

    }

}
