﻿using System.Text;
using System.Linq;
using System.Windows.Documents;
using System.Windows.Media;
using System.Net;
using System;

namespace TextHtmlTransformer
{
    public class FlowDocumentToHtmlConverter
    {
        public static string Convert(FlowDocument flowDocument)
        {
            StringBuilder result = new StringBuilder();
            result.Append("<pre>");

            foreach (var block in flowDocument.Blocks)
            {
                convert(block, result);
            }

            result.Append("</pre>");
            return result.ToString();
        }

        private static void convert(Block block, StringBuilder result)
        {
            if (block is Paragraph)
            {
                Paragraph paragraph = block as Paragraph;
                var span = new SpanModel();

                foreach (var inline in paragraph.Inlines)
                {
                    span.Children.Add(convert(inline));
                }

                result.Append(SpanToString(span, "") + "\n");
            }
        }

        private static string SpanToString(SpanModel model, string parentColor)
        {
            string result = "";

            foreach(var child in model.Children)
            {
                if(child is RunModel)
                {
                    var run = child as RunModel;
                    result += RunToString(run, model.Color);
                }

                if(child is SpanModel)
                {
                    var span = child as SpanModel;

                    if(span.Color != parentColor)
                    {
                        result += span.GetSpanStart();
                    }

                    result += SpanToString(span, model.Color);

                    if (span.Color != parentColor)
                    {
                        result += span.GetSpanEnd();
                    }
                }
            }

            return result;
        }

        private static string RunToString(RunModel run, string parentColor)
        {
            if(run.Color == parentColor)
            {
                return run.GetTextContent();
            }
            else
            {
                return run.ToString();
            }
        }

        private static InlineModel convert(Inline inline)
        {
            if(inline is Run)
            {
                return new RunModel
                {
                    Text = WebUtility.HtmlEncode((inline as Run).Text),
                    Color = getForegroundColorText(inline)
                };
            }

            if (inline is Span)
            {
                var span = inline as Span;
                return new SpanModel
                {
                    Color = getForegroundColorText(inline),
                    Children = span.Inlines.Select(i => convert(i)).ToList(),
                };
            }

            return null;
        }

        private static string getForegroundColorText(Inline inline)
        {
            return "#" + (inline.Foreground as SolidColorBrush).Color.ToString().Substring(3);
        }
    }
}
