﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;

namespace TextHtmlTransformer.Tests
{

    [TestFixture]
    public class InlineModelTest
    {
        [Test]
        public void Inline()
        {
            var inlineModel = new RunModel();
            inlineModel.Text = "Test";
            Assert.AreEqual("Test", inlineModel.ToString());
            inlineModel.Color = "#0000FF";
            Assert.AreEqual("<span style=\"color:#0000FF;\">Test</span>", inlineModel.ToString());

            inlineModel.Color = "#000000";
            Assert.AreEqual("Test", inlineModel.ToString());
        }

        [Test]
        public void Span()
        {
            var span = new SpanModel();
            span.Children.Add(new RunModel { Text = "Child" });
            Assert.AreEqual("Child", span.ToString());
            span.Color = "#00FF00";
            Assert.AreEqual("<span style=\"color:#00FF00;\">Child</span>", span.ToString());
        }
    }
}
