﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace SilverlightClock
{
    public partial class ClockControl : UserControl
    {
        public ClockControl()
        {
            InitializeComponent();
        }

        private void UserControl_Loaded(object sender, RoutedEventArgs e)
        {
            DrawMarkers();
        }

        private void DrawMarkers()
        {
            MarkerCanvas.Children.Clear();

            for (int i = 0; i < 60; ++i)
            {
                if (i % 5 == 0)
                {
                    int hour = i / 5;
                    drawHourMark(hour);
                    drawHourNumber(hour);
                }
                else
                {
                    drawMinuteMark(i);
                }

            }
        }

        private void drawHourMark(int hour)
        {
            Rectangle markerRectangle = new Rectangle
            {
                Width = 3,
                Height = 8,
                Fill = new SolidColorBrush(Colors.Gray),
            };

            var renderTransform = this.CreateTransform(
                hour * (360 / 12),
                -(markerRectangle.Width / 2),
                -(markerRectangle.Height * 2 + 4.5 - ClockFaceEllipse.StrokeThickness / 2 - this.Height / 2)
                );
            markerRectangle.RenderTransform = renderTransform;
            MarkerCanvas.Children.Add(markerRectangle);
            
        }

        private void drawHourNumber(int hour)
        {
            double angleRadian = hour / 12d * 2 * Math.PI;
            TextBlock textBlock = new TextBlock
                {
                    Text = hour.ToString(),
                    FontSize = 20,
                    HorizontalAlignment= HorizontalAlignment.Center
                };
            textBlock.RenderTransform = new TransformGroup
                    {
                        Children =
                        {
                            new TranslateTransform{X = Width / 2, Y = Height / 2 },
                            new TranslateTransform
                            {
                                X = (Width / 2 - ClockFaceEllipse.StrokeThickness * 2 - 10) * Math.Sin(angleRadian) - 15 / 2 ,
                                Y = (Height / 2- ClockFaceEllipse.StrokeThickness * 2 - 10) * -Math.Cos(angleRadian) - 30 / 2
                            }
                        }
                    };
            MarkerCanvas.Children.Add(textBlock);
        }

        private void drawMinuteMark(int minute)
        {
            Rectangle markerRectangle = new Rectangle
            {
                Width = 1,
                Height = 4,
                Fill = new SolidColorBrush(Colors.Gray)
            };

            markerRectangle.RenderTransform = this.CreateTransform(
                minute * 6,
                -(markerRectangle.Width / 2),
                -(markerRectangle.Height * 2 + 12.75 - ClockFaceEllipse.StrokeThickness / 2 - this.Height / 2)
                );
            MarkerCanvas.Children.Add(markerRectangle);
        }

        private TransformGroup CreateTransform(
            double angle,
            double firstTranslateXValue,
            double firstTranslateYValue
            )
        {
            TransformGroup transformGroup = new TransformGroup();

            TranslateTransform firstTranslate = new TranslateTransform
            {
                X = firstTranslateXValue,
                Y = firstTranslateYValue
            };
            transformGroup.Children.Add(firstTranslate);

            RotateTransform rotateTransform = new RotateTransform
            {
                Angle = angle
            };
            transformGroup.Children.Add(rotateTransform);

            TranslateTransform secondTranslate = new TranslateTransform
            {
                X = this.Width / 2,
                Y = this.Height / 2
            };
            transformGroup.Children.Add(secondTranslate);

            return transformGroup;
        }

    }
}
