﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.ComponentModel;

namespace SilverlightClock
{
    public class ClockViewModel:INotifyPropertyChanged
    {

        public event PropertyChangedEventHandler PropertyChanged = delegate { };

        protected void NotifyPropertyChanged(string propertyName)
        {
            PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }

        private double secondAngle;
        public double SecondAngle
        {
            get { return secondAngle; }
            set
            { 
                secondAngle = value;
                NotifyPropertyChanged("SecondAngle");
            }
        }

        private double minuteAngle;
        public double MinuteAngle
        {
            get { return minuteAngle; }
            set
            {
                minuteAngle = value;
                NotifyPropertyChanged("MinuteAngle");
            }
        }

        private double hourAngle;
        public double HourAngle
        {
            get { return hourAngle; }
            set
            {
                hourAngle = value;
                NotifyPropertyChanged("HourAngle");
            }
        }


        public ClockViewModel()
        {
            CompositionTarget.Rendering += Update;
        }

        bool previouslyCalled = false;

        private void Update(object sender, EventArgs e)
        {
            if (previouslyCalled)
            {
                previouslyCalled = true; 
                return;
            }

            DateTime now = DateTime.Now;

            double secondAngle = now.Second * (360 / 60);
            if (this.SecondAngle != secondAngle)
            {
                SecondAngle = secondAngle;
            }

            double minuteAngle = now.Minute * (360 / 60) + now.Second / 60d * (360 / 60);
            if (this.MinuteAngle != minuteAngle)
            {
                MinuteAngle = minuteAngle;
            }

            double hourAngle = now.Hour * (360 / 12) + now.Minute / 60d * (360 / 12);
            if (this.HourAngle != hourAngle)
            {
                HourAngle = hourAngle;
            }
        }

        enum DayTimePeriod
        {
            AnteMeridiem = 0,
            PostMeridiem = 1
        }

        int ToSeconds(int day, DayTimePeriod period, int hour, int minute, int second)
        {
            return day * 24 * 60 * 60 
                +(int)period * 12 * 60 * 60
                + hour * 60 * 60 
                + minute * 60 
                + second;
        }
    }
}
