﻿using System.Windows;
using System.Windows.Controls;

namespace SilverlightGrayScottSimulation
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();
            viewModel = (GrayScottViewModel)Resources["viewModel"];
        }


        bool isMouseLeftButtonDown;

        private void image_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            isMouseLeftButtonDown = true;
            viewModel.MouseDown(e, image);
        }

        private void image_MouseLeftButtonUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            isMouseLeftButtonDown = false;
            viewModel.MouseUp();
        }

        private void image_MouseMove(object sender, System.Windows.Input.MouseEventArgs e)
        {
            if (!isMouseLeftButtonDown) { return; }

            viewModel.MouseDown(e, image);
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            viewModel.ToggleExecutionMode();
        }


    }
}
