﻿using System;
using System.ComponentModel;

namespace SilverlightGrayScottSimulation
{
    public class PhysicalParameterViewModel:ViewModel
    {
        public string Name { get; private set; }

        Func<double> getter;
        Action<double> setter;

        public double Value
        {
            get { return getter(); }
            set
            {
                setter(value);
                NotifyPropertyChanged("Value");
            }
        }

        public PhysicalParameterViewModel(
            string parameterName,
            Func<double> getter,
            Action<double> setter
            )
        {
            this.Name = parameterName;
            this.getter = getter;
            this.setter = setter;
        }

    }

    public class ViewModel : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected void NotifyPropertyChanged(string propertyName)
        {
            if (PropertyChanged == null) return;
            PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }
    }

}
