﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace SimpleEvolutionLogics.BooleanNetworks
{
    public class BooleanNetwork
    {
        public IEnumerable<BooleanNode> Genes { get { return nodes; } }

        List<BooleanNode> nodes = new List<BooleanNode>();

        Random random = new Random();

        private BooleanNetwork() { }

        private TwoConnection createRandomConnection(BooleanNode node)
        {
            var node1 = random.Next(nodes);
            var node2 = random.Next(nodes);
            return new TwoConnection(random.Next(BooleanOperator.Operators), node1, node2);
        }

        public static BooleanNetwork CreateRandom(int count)
        {
            BooleanNetwork network = new BooleanNetwork();

            for (int i = 0; i < count; i++)
            {
                network.nodes.Add(new BooleanNode { });
            }

            foreach (var node in network.nodes)
            {
                node.IsOn = network.random.NextBool();
                node.NextValueSource = network.createRandomConnection(node);
            }

            return network;
        }

        public static BooleanNetwork CreateFrom(IEnumerable<BooleanNode> nodes)
        {
            BooleanNetwork result = new BooleanNetwork();
            result.nodes.AddRange(nodes);
            return result;
        }

        public void Update()
        {
            ApplyPreviousState();
            UpdateFromPreviousState();
        }

        public void ApplyPreviousState()
        {
            foreach (var node in nodes)
            {
                node.CheckNext();
            }
        }

        public void UpdateFromPreviousState()
        {
            foreach (var node in nodes)
            {
                node.Update();
            }
        }
    }
}
