﻿
namespace BooleanNetworkDemo
{
    class HistoryLog
    {
        public bool[,] Data { get; private set; }

        public HistoryLog(int logCount, int stateCount)
        {
            Data = new bool[logCount, stateCount];
        }

        public int LastLogCount
        {
            get { return LogCount - 1; }
        }

        public int LogCount
        {
            get { return Data.GetLength(0); }
        }

        public void AddLog(System.Collections.Generic.IEnumerable<bool> log)
        {
            for (int i = 0; i < LogCount - 1; i++)
            {
                for (int j = 0; j < Data.GetLength(1); j++)
                {
                    Data[LastLogCount - i, j]
                        = Data[LastLogCount - i - 1, j];
                }
            }


            int index = 0;

            foreach (var state in log)
            {
                Data[0, index] = state;
                index++;
            }
        }

        public void SetLogCount(int newLogCount)
        {
            bool[,] newData = new bool[newLogCount, Data.GetLength(1)];

            int maxLogCount = System.Math.Min(newLogCount, LogCount);

            for (int i = 0; i < maxLogCount; i++)
            {
                for (int j = 0; j < Data.GetLength(1); j++)
                {
                    newData[i, j] = Data[i, j];
                }
            }

            this.Data = newData;
        }
    }
}
