﻿using System.Collections.ObjectModel;
using SimpleEvolutionLogics.BooleanNetworks;
using System.Linq;

namespace BooleanNetworkDemo
{
    public class MainViewModel:ViewModel
    {
        private ObservableCollection<NodeViewModel> nodes;
        public ObservableCollection<NodeViewModel> Nodes
        {
            get { return nodes; }
            set { nodes = value; NotifyPropertyChanged("Nodes"); }
        }

        public ObservableCollection<ObservableCollection<NodeViewModel>> history;
        public ObservableCollection<ObservableCollection<NodeViewModel>> History {
            get { return history; }
            set { history = value; NotifyPropertyChanged("History"); }
        }

        private PauseStartMode pauseStartMode;
        public PauseStartMode PauseStartMode { 
            get { return pauseStartMode; }
            set
            {
                pauseStartMode = value;
                NotifyPropertyChanged("PauseStopMode");
            }
        }


        public int LogCount{  get;  set;}
        public int GeneCount { get; set; }

        public void UpdateLogCount(int value)
        {
            historyModel.SetLogCount(value);

            if (value > History.Count)
            {
                int additionCount = value - History.Count;
                addLogViewModel(additionCount);
            }
            else
            {
                int removeCount = History.Count - value;
                for (int i = 0; i < removeCount; i++)
                {
                    History.RemoveAt(History.Count - 1);
                }
            }
        }

        private BooleanNetwork booleanNetwork;
        private HistoryLog historyModel;
       

        public MainViewModel()
        {
            GeneCount = 10;
            LogCount = 20;
            initNetwork();
        }

        private void initNetwork()
        {
            booleanNetwork = BooleanNetwork.CreateRandom(GeneCount);
            Nodes = new ObservableCollection<NodeViewModel>();

            addNodeViewModels(Nodes, booleanNetwork.Genes.Count());

            History = new ObservableCollection<ObservableCollection<NodeViewModel>>();
            addLogViewModel(LogCount);
            historyModel = new HistoryLog(History.Count, booleanNetwork.Genes.Count());
        }

        private void addLogViewModel(int count)
        {
            for (int i = 0; i < count; i++)
            {
                var logViewModel = new ObservableCollection<NodeViewModel>();
                History.Add(logViewModel);
                addNodeViewModels(logViewModel, booleanNetwork.Genes.Count());
            }
        }

        private void addNodeViewModels(ObservableCollection<NodeViewModel> dest, int count)
        {
            for (int i = 0; i < count; i++)
            {
                dest.Add(new NodeViewModel());
            }
        }

        public void Update()
        {
            BooleanNode[] nodes = booleanNetwork.Genes.ToArray();
            prepareToUpdate(nodes);
            updateHistory(nodes);
            updateBooleanNodes(nodes);
        }

        private void prepareToUpdate(BooleanNode[] nodes)
        {
            for (int i = 0; i < nodes.Length; i++)
            {
                nodes[i].IsOn = Nodes[i].State;
            }
        }

        private void updateHistory(BooleanNode[] nodes)
        {
            historyModel.AddLog(nodes.Select(n => n.IsOn));

            for (int i = 0; i < History.Count; i++)
            {
                for (int j = 0; j < History[i].Count; j++)
                {
                    History[i][j].State = historyModel.Data[i, j];
                }
            }
        }

        private void updateBooleanNodes(BooleanNode[] nodes)
        {
            booleanNetwork.Update();

            for (int i = 0; i < nodes.Length; i++)
            {
                Nodes[i].State = nodes[i].IsOn;
            }
        }

        public void CreateNewNetwork()
        {
            initNetwork();
        }
    }
}
