﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace SimpleEvolutionLogics.BooleanNetworks
{
    public struct BooleanNodeInput
    {
        public BooleanNode Node1;
        public BooleanNode Node2;

        public BooleanNodeInput(BooleanNode node1, BooleanNode node2)
        {
            this.Node1 = node1;
            this.Node2 = node2;
        }
    }

    public class MultiOrInput : INextValueSource
    {
        List<BooleanNodeInput> inputs = new List<BooleanNodeInput>();

        public BooleanOperator Operator{get;private set;}

        public MultiOrInput(BooleanOperator booleanOperator)
        {
            if (booleanOperator == null) throw new ArgumentException();
            Operator = booleanOperator;
        }

        public int Count
        {
            get { return inputs.Count; }
        }

        public bool NextValue
        {
            get
            {
                bool anyOn1 = false;
                bool anyOn2 = false;

                foreach (var input in inputs)
                {
                    if (input.Node1.IsOn) { anyOn1 = true; }
                    if (input.Node2.IsOn) { anyOn2 = true; }
                }
                return Operator.Process(anyOn1, anyOn2);
            }
        }


        public void Add(BooleanNode node1, BooleanNode node2)
        {
            inputs.Add(new BooleanNodeInput(node1, node2));
        }

        public void Remove(BooleanNode node1, BooleanNode node2)
        {
            Remove(new BooleanNodeInput(node1, node2));
        }

        public void Remove(BooleanNodeInput booleanNodeInput)
        {
            inputs.Remove(booleanNodeInput);
        }
    }
}
