﻿using System;
using System.Windows.Controls;
using System.Windows.Threading;

namespace BooleanNetworkDemo
{
    public partial class MainPage : UserControl
    {
        DispatcherTimer timer= new DispatcherTimer();

        public MainPage()
        {
            InitializeComponent();
            mainViewModel = (MainViewModel)Resources["mainViewModel"];

            timer.Interval = TimeSpan.FromMilliseconds(500);
            timer.Tick += delegate { mainViewModel.Update(); };
            timer.Start();
        }

        private void Button_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            if (mainViewModel.PauseStartMode == PauseStartMode.Pause)
            {
                timer.Stop();
                mainViewModel.PauseStartMode = PauseStartMode.Stop;
            }
            else
            {
                timer.Start();
                mainViewModel.PauseStartMode = PauseStartMode.Pause;
            }
        }

        private void ResetLogCountButton_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            mainViewModel.UpdateLogCount(mainViewModel.LogCount);
        }
        private void CreateNewNetworkButton_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            mainViewModel.CreateNewNetwork();
        }

        private void slider1_ValueChanged(object sender, System.Windows.RoutedPropertyChangedEventArgs<double> e)
        {
            Slider slider1 = (Slider)sender;
            double speed = slider1.Value;
            timer.Interval = TimeSpan.FromMilliseconds(1000 / speed);
        }
    }
}
