﻿using System;
using System.Windows.Input;


namespace BooleanNetworkDemo
{
    public class DelegateCommand : ICommand
    {
        Func<bool> canExecute;
        Action execute;

        public DelegateCommand(Action execute, Func<bool> canExecute)
        {
            this.execute = execute;
            this.canExecute = canExecute;
        }

        public DelegateCommand(Action execute):this(execute, ()=> true)
        {
        }

        public bool CanExecute(object parameter)
        {
            return canExecute();
        }

        public event EventHandler CanExecuteChanged = delegate { };

        public void Execute(object parameter)
        {
            execute();
        }

        public void NotifyCanExecuteChanged()
        {
            CanExecuteChanged(this, EventArgs.Empty);
        }
    }
}
