﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace SimpleEvolutionLogics.BooleanNetworks
{
    public class BooleanOperator
    {
        public Func<bool, bool, bool> Process { get; private set; }
        public string Name { get; private set; }

        public BooleanOperator(Func<bool, bool, bool> logic, string name)
        {
            this.Name = name;
            this.Process = logic;
        }

        public static readonly BooleanOperator And = new BooleanOperator((b1, b2) => b1 && b2, "And");
        public static readonly BooleanOperator Or = new BooleanOperator((b1, b2) => b1 || b2, "Or");
        public static readonly BooleanOperator NotAnd = new BooleanOperator((b1, b2) => !(b1 && b2), "Not And");
        public static readonly BooleanOperator NotOr = new BooleanOperator((b1, b2) => !(b1 || b2), "Not Or");

        public static readonly BooleanOperator Equal = new BooleanOperator((b1, b2) => b1 == b2, "Equal");
        public static readonly BooleanOperator NotEqual = new BooleanOperator((b1, b2) => b1 != b2, "Not Equal");

        public static readonly BooleanOperator Node1 = new BooleanOperator((b1, b2) => b1, "Node1");
        public static readonly BooleanOperator Node2 = new BooleanOperator((b1, b2) => b2, "Node2");
        public static readonly BooleanOperator NotNode1 = new BooleanOperator((b1, b2) => !b1, "Not Node1");
        public static readonly BooleanOperator NotNode2 = new BooleanOperator((b1, b2) => !b2, "Not Node2");


        public static readonly BooleanOperator ActuatorRemoverAndActuator 
            = new BooleanOperator((b1, b2) => b1 ? false : b2, "Actuator Remover And Actuator");
        public static readonly BooleanOperator InhibitorRemoverAndInhibitor 
            = new BooleanOperator((b1, b2) => !(b1 ? false : b2), "Inhibitor Remover And Inhibitor");
        public static readonly BooleanOperator ActuatorAndActuatorRemover 
            = new BooleanOperator((b1, b2) => b2 ? false : b1, "Actuator And Actuator Remover");
        public static readonly BooleanOperator InhibitorAndInhibitorRemover 
            = new BooleanOperator((b1, b2) => !(b2 ? false : b1), "Inhibitor And Inhibitor Remover");

        public static readonly BooleanOperator True = new BooleanOperator((b1, b2) => true, "True");
        public static readonly BooleanOperator False = new BooleanOperator((b1, b2) => false, "False");

        public static readonly BooleanOperator[] Operators = { 
                                                    And, Or,
                                                    NotAnd, NotOr,

                                                    Equal, NotEqual,

                                                    Node1, Node2,
                                                    NotNode1, NotNode2,

                                                    ActuatorRemoverAndActuator, InhibitorRemoverAndInhibitor,
                                                    ActuatorAndActuatorRemover, InhibitorAndInhibitorRemover,

                                                    True, False
        };
    }
}
