﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace SimpleEvolutionLogics
{
    public static class RandomExtension
    {
        public static T Next<T>(this Random random, IList<T> list)
        {
            return list[random.Next(list.Count)];
        }


        public static T Next<T>(this Random random, IList<T> list, params T[] exceptFor)
        {
            if (list.Count == exceptFor.Length) { throw new ArgumentException(); }

            while (true)
            {
                var test = list[random.Next(list.Count)];

                if (!exceptFor.Contains(test)) { return test; }
            }
        }

        public static bool NextBool(this Random random)
        {
            return random.Next(2) == 1;
        }
    }
}
