﻿using System;

namespace TrackingAndEvadingVehicles
{
    public class PointLight
    {
        public Vector2D Position { get; set; }
        public double Quantity { get; set; }
    }

    public class LightSensor
    {
        public Vector2D Position { get; set; }
        public Vector2D Direction { get; set; }
        public double Size { get; set; }


        public double GetValue()
        {
            var lightDirection = Light.Position - Position;
            double dot = Vector2D.Multiply(
                Vector2D.Normalize(lightDirection),
                Direction
                );

            if (dot < 0) return 0;

            return Math.Min(
                dot * Light.Quantity * Size / ((Position - Light.Position).Length() * 2 * Math.PI),
                Light.Quantity
                );
        }

        public PointLight Light { get; set; }
    }

}
