﻿using System;

namespace GeneticAlgorithms
{
    public abstract class GeneticAlgorithmOperations<T> where T : Individual
    {
        public abstract T CreateAtRandom(Random random);
        public abstract T Copy(T selected);
        public abstract void Crossover(T a, T b, Random random);
        public abstract void Mutate(T individual, Random random, double rate);
    }
}
