﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SilverlightEvolutionOfRayTrackingVehicle
{
    class Genome
    {
        public double[] LeftWeights;
        public double[] RightWeights;

        public Genome(Random random)
        {
            LeftWeights = Enumerable.Range(0, 8)
                .Select((n) => random.NextDouble() * 2 - 1)
                .ToArray();

            RightWeights = Enumerable.Range(0, 8)
                .Select((n) => random.NextDouble() * 2 - 1)
                .ToArray();
        }

        public Genome() { }

        public Genome Copy()
        {
            Genome result = new Genome();
            result.LeftWeights = Enumerable.Range(0, LeftWeights.Length)
                .Select((n) => LeftWeights[n]).ToArray();
            result.RightWeights = Enumerable.Range(0, RightWeights.Length)
                .Select((n) => RightWeights[n]).ToArray();
            return result;
        }

        public void Mutate(Random random, double rate)
        {
            for (int i = 0; i < LeftWeights.Length; i++)
            {
                if (random.NextDouble() < rate)
                {
                    LeftWeights[i] = random.NextDouble() * 2 - 1;
                }
            }
            for (int i = 0; i < RightWeights.Length; i++)
            {
                if (random.NextDouble() < rate)
                {
                    RightWeights[i] = random.NextDouble() * 2 - 1;
                }
            }
        }

        public static void Crossover(Genome g1, Genome g2, Random random)
        {
            for (int i = 0; i < g1.LeftWeights.Length; i++)
            {
                if (random.NextDouble() < 0.5)
                {
                    double swap = g1.LeftWeights[i];
                    g1.LeftWeights[i] = g2.LeftWeights[i];
                    g2.LeftWeights[i] = swap;
                }
            }
            for (int i = 0; i < g1.RightWeights.Length; i++)
            {
                if (random.NextDouble() < 0.5)
                {
                    double swap = g1.RightWeights[i];
                    g1.RightWeights[i] = g2.RightWeights[i];
                    g2.RightWeights[i] = swap;
                }
            }
        }
    }
}
