﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace GeneticAlgorithms
{
    public class GeneticAlgorithm<T> where T : Individual
    {
        public List<T> Individuals { get; set; }
        public GeneticAlgorithmOperations<T> Operations { get; private set; }
        private Random random;

        public GeneticAlgorithm(GeneticAlgorithmOperations<T> operations, Random random, int individualCount)
        {
            Individuals = new List<T>();
            this.Operations = operations;
            this.random = random;

            for (int i = 0; i < individualCount; i++)
            {
                Individuals.Add(operations.CreateAtRandom(random));
            }
        }

        public void Select()
        {
            RouletteWheel roulette = new RouletteWheel(Individuals.Select(i => i.GetFitness()).ToArray());

            int individualCount = Individuals.Count;

            List<T> nextGeneration = new List<T>();

            for (int i = 0; i < individualCount; i++)
            {
                var selected = Individuals[roulette.GetValue(random.NextDouble())];
                nextGeneration.Add(Operations.Copy(selected));
            }

            this.Individuals = nextGeneration;
        }

        public void Mutate(double rate)
        {
            foreach (var individual in Individuals)
            {
                Operations.Mutate(individual, random, rate);
            }
        }

        public void Cross(double rate)
        {
            int crossPairCount = (Individuals.Count / 2);

            for (int i = 0; i < crossPairCount * 2; i+= 2)
            {
                if (random.NextDouble() > rate) continue;

                Operations.Crossover(Individuals[i], Individuals[i + 1], random);
            }
        }

        public void NextGeneration(double crossovereRate, double mutateRAte)
        {
            Select();
            Cross(crossovereRate);
            Mutate(mutateRAte);
        }
    }
}
