﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace GeneticAlgorithms
{
    public class RouletteWheel
    {
        private double[] fitnesses;

        public RouletteWheel(double[] fitnesses)
        {
            this.fitnesses = fitnesses;
        }

        public int GetValue(double ratio)
        {
            double sum = 0;
            double total = fitnesses.Sum();

            for (int i = 0; i < fitnesses.Length; i++)
            {
                sum += fitnesses[i];

                if (sum / total> ratio)
                {
                    return i;
                }

            }

            return 0;
        }
    }
}
