﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using GeneticAlgorithms;

namespace SilverlightEvolutionOfRayTrackingVehicle
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();
            this.viewModel = (ConfigurationViewModel)Resources["viewModel"];
        }
        
        World visibleWorld;
        GeneticAlgorithm<World> ga;
        Random random = new Random();

        int loopCount;

        ConfigurationViewModel viewModel;

        private void UserControl_Loaded(object sender, RoutedEventArgs e)
        {
            Initialize();

            CompositionTarget.Rendering += delegate
            {
                Update();
                Draw();
            };
        }

        private void Initialize()
        {
            loopCount = 0;
            ga = new GeneticAlgorithm<World>(new WorldGAOperations(), random, 100);

            initializeWorlds();
        }

        private void initializeWorlds()
        {
            foreach (var world in ga.Individuals)
            {
                world.Initialize();
                world.SetRandomLightPosition(random, 300);
            }

            visibleWorld = ga.Operations.Copy(ga.Individuals[0]);
            visibleWorld.Initialize();
        }

        Point mousePosition;

        private void Update()
        {
            loopCount++;

            if (loopCount > viewModel.OneGenerationSeconds * 60)
            {
                addFitness(ga.Individuals.Average(i => i.GetFitness()));
                loopCount = 0;
                ga.NextGeneration(viewModel.CrossoverRate, viewModel.MutationRate);
                initializeWorlds();
            }

            var position = mousePosition;
            visibleWorld.Light.Position = new Vector2D(position.X, position.Y);
            visibleWorld.Update();

            foreach (var world in ga.Individuals)
            {
                world.Update();
            }
        }

        List<double> fitnessLog = new List<double>();

        private void addFitness(double fitness)
        {
            fitnessLog.Add(fitness);

            fitnessView.Points.Clear();


            for (int i = 0; i < fitnessLog.Count ; i++)
            {
                fitnessView.Points.Add(new Point(i * 4, fitnessLog[i] / 50));
            }
        }


        private void Draw()
        {
            var vehicle = visibleWorld.Vehicle;
            vehicleView.RenderTransform = new RotateTransform { Angle = vehicle.Rotation };
            vehicleView.RenderTransformOrigin = new Point(0.5, 0.5);
            Canvas.SetLeft(vehicleView, vehicle.Position.X - vehicle.Radius);
            Canvas.SetTop(vehicleView, vehicle.Position.Y - vehicle.Radius);

            Canvas.SetLeft(pointLightView, mousePosition.X - pointLightView.Width / 2);
            Canvas.SetTop(pointLightView, mousePosition.Y - pointLightView.Height / 2);
        }

        private void restartButton_Click(object sender, RoutedEventArgs e)
        {
            Initialize();
            fitnessLog.Clear();
        }

        private void Canvas_MouseMove(object sender, MouseEventArgs e)
        {
            mousePosition = e.GetPosition(null);
        }

    }
}
