﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BackPropagation
{
    public class SignalNode
    {
        public double Value;
    }

    public abstract class Neuron : SignalNode
    {
        public double Bias;
        public double DeltaBias;
        public double DeltaWeight;

        public const double LearningFactor = 0.75;
        public const double Stabilizer = 0.8;

        public List<Connection> SourceConnections = new List<Connection>();


        public void UpdateOutput()
        {
            Value = sigmoid(SourceConnections.Sum(c=>c.Weight * c.Source.Value) + Bias);
        }

        static double sigmoid(double x)
        {
            return (1 / (1 + Math.Exp(-(x))));
        }

        public void UpdateBias()
        {
            DeltaBias = LearningFactor * DeltaWeight + Stabilizer * DeltaBias;
            Bias += DeltaBias;
        }

        public void UpdateDeltaWeight()
        {
            DeltaWeight = Value * (1 - Value) * GetTeacherSignal();
        }

        public abstract double GetTeacherSignal();
    }


    public class OutputNeuron : Neuron
    {
        public double ExpectedValue;

        public override double GetTeacherSignal()
        {
            return ExpectedValue - Value;
        }
    }

    public class HiddenNeuron : Neuron
    {
        public List<Connection> DestConnections = new List<Connection>();

        public override double GetTeacherSignal()
        {
            return DestConnections.Sum(c=>c.Dest.DeltaWeight * c.Weight);
        }
    }

    public class Connection
    {
        public double Weight;
        public double DeltaWeight;

        public SignalNode Source;
        public Neuron Dest;

        public void UpdateWeight()
        {
            DeltaWeight = Neuron.LearningFactor * Dest.DeltaWeight * Source.Value 
                + Neuron.Stabilizer * DeltaWeight;
            Weight += DeltaWeight;
        }
    }
}
